/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenRepositoryContentDescriptor;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultMavenRepositoryContentDescriptor;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.MavenRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultGradleModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMavenPomMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultMavenArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements MavenArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private static final DefaultMavenPomMetadataSource.MavenMetadataValidator NO_OP_VALIDATION_SERVICES = new DefaultMavenPomMetadataSource.MavenMetadataValidator(){

        @Override
        public boolean isUsableModule(String repoName, MutableMavenModuleResolveMetadata metadata, ExternalResourceArtifactResolver artifactResolver) {
            return true;
        }
    };
    private final Transformer<String, MavenArtifactRepository> describer;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private Object url;
    private List<Object> additionalUrls = new ArrayList<Object>();
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final ModuleMetadataParser metadataParser;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final FileStore<String> resourcesFileStore;
    private final FileResourceRepository fileResourceRepository;
    private final MavenMutableModuleMetadataFactory metadataFactory;
    private final IsolatableFactory isolatableFactory;
    private final MavenMetadataSources metadataSources = new MavenMetadataSources();
    private final InstantiatorFactory instantiatorFactory;

    public DefaultMavenArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, FeaturePreviews featurePreviews, MavenMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory) {
        this(new DefaultDescriber(), fileResolver, transportFactory, locallyAvailableResourceFinder, instantiatorFactory, artifactFileStore, pomParser, metadataParser, authenticationContainer, moduleIdentifierFactory, resourcesFileStore, fileResourceRepository, featurePreviews, metadataFactory, isolatableFactory, objectFactory);
    }

    public DefaultMavenArtifactRepository(Transformer<String, MavenArtifactRepository> describer, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, FeaturePreviews featurePreviews, MavenMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory, ObjectFactory objectFactory) {
        super(instantiatorFactory.decorate(), authenticationContainer, objectFactory);
        this.describer = describer;
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
        this.metadataParser = metadataParser;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.resourcesFileStore = resourcesFileStore;
        this.fileResourceRepository = fileResourceRepository;
        this.metadataFactory = metadataFactory;
        this.isolatableFactory = isolatableFactory;
        this.metadataSources.setDefaults(featurePreviews);
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public String getDisplayName() {
        return (String)this.describer.transform((Object)this);
    }

    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    public void setUrl(URI url) {
        this.invalidateDescriptor();
        this.url = url;
    }

    public void setUrl(Object url) {
        this.invalidateDescriptor();
        this.url = url;
    }

    public Set<URI> getArtifactUrls() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Object additionalUrl : this.additionalUrls) {
            result.add(this.fileResolver.resolveUri(additionalUrl));
        }
        return result;
    }

    public void artifactUrls(Object ... urls) {
        this.invalidateDescriptor();
        this.additionalUrls.addAll(Lists.newArrayList((Object[])urls));
    }

    public void setArtifactUrls(Set<URI> urls) {
        this.invalidateDescriptor();
        this.setArtifactUrls((Iterable<?>)urls);
    }

    public void setArtifactUrls(Iterable<?> urls) {
        this.invalidateDescriptor();
        this.additionalUrls = Lists.newArrayList(urls);
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    @Override
    protected RepositoryDescriptor createDescriptor() {
        this.validate();
        return ((MavenRepositoryDescriptor.Builder)((MavenRepositoryDescriptor.Builder)((MavenRepositoryDescriptor.Builder)new MavenRepositoryDescriptor.Builder(this.getName(), this.getUrl()).setAuthenticated(this.getConfiguredCredentials() != null)).setAuthenticationSchemes((List)this.getAuthenticationSchemes())).setMetadataSources((List)this.metadataSources.asList())).setArtifactUrls(Sets.newHashSet(this.getArtifactUrls())).create();
    }

    private void validate() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException("You must specify a URL for a Maven repository.");
        }
    }

    protected MavenResolver createRealResolver() {
        this.validate();
        MavenResolver resolver = this.createResolver(this.getUrl());
        for (URI repoUrl : this.getArtifactUrls()) {
            resolver.addArtifactLocation(repoUrl);
        }
        return resolver;
    }

    private MavenResolver createResolver(URI rootUri) {
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        MavenMetadataLoader mavenMetadataLoader = new MavenMetadataLoader(transport.getResourceAccessor(), this.resourcesFileStore);
        ImmutableMetadataSources metadataSources = this.createMetadataSources(mavenMetadataLoader);
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.instantiatorFactory, this.getUrl(), this.resourcesFileStore);
        InstantiatingAction<ComponentMetadataSupplierDetails> supplier = this.createComponentMetadataSupplierFactory(injector, this.isolatableFactory);
        InstantiatingAction<ComponentMetadataListerDetails> lister = this.createComponentMetadataVersionLister(injector, this.isolatableFactory);
        return new MavenResolver(this.getName(), rootUri, transport, this.locallyAvailableResourceFinder, this.artifactFileStore, this.moduleIdentifierFactory, metadataSources, MavenMetadataArtifactProvider.INSTANCE, mavenMetadataLoader, supplier, lister, injector);
    }

    public void metadataSources(Action<? super MavenArtifactRepository.MetadataSources> configureAction) {
        this.invalidateDescriptor();
        this.metadataSources.reset();
        configureAction.execute((Object)this.metadataSources);
    }

    public void mavenContent(Action<? super MavenRepositoryContentDescriptor> configureAction) {
        this.content((Action<? super RepositoryContentDescriptor>)((Action)Cast.uncheckedCast(configureAction)));
    }

    ImmutableMetadataSources createMetadataSources(MavenMetadataLoader mavenMetadataLoader) {
        ImmutableList.Builder sources = ImmutableList.builder();
        if (this.metadataSources.gradleMetadata) {
            boolean listVersionsForGradleMetadata = !this.metadataSources.mavenPom;
            sources.add((Object)new DefaultGradleModuleMetadataSource(this.getMetadataParser(), this.metadataFactory, listVersionsForGradleMetadata));
        }
        if (this.metadataSources.mavenPom) {
            sources.add((Object)new DefaultMavenPomMetadataSource(MavenMetadataArtifactProvider.INSTANCE, this.getPomParser(), this.fileResourceRepository, this.getMetadataValidationServices(), mavenMetadataLoader));
        }
        if (this.metadataSources.artifact) {
            sources.add((Object)new DefaultArtifactMetadataSource(this.metadataFactory));
        }
        return new DefaultImmutableMetadataSources((Iterable<MetadataSource<?>>)sources.build());
    }

    protected DefaultMavenPomMetadataSource.MavenMetadataValidator getMetadataValidationServices() {
        return NO_OP_VALIDATION_SERVICES;
    }

    private MetaDataParser<MutableMavenModuleResolveMetadata> getPomParser() {
        return this.pomParser;
    }

    private ModuleMetadataParser getMetadataParser() {
        return this.metadataParser;
    }

    FileStore<ModuleComponentArtifactIdentifier> getArtifactFileStore() {
        return this.artifactFileStore;
    }

    FileStore<String> getResourcesFileStore() {
        return this.resourcesFileStore;
    }

    RepositoryTransport getTransport(String scheme) {
        return this.transportFactory.createTransport(scheme, this.getName(), this.getConfiguredAuthentication());
    }

    protected LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> getLocallyAvailableResourceFinder() {
        return this.locallyAvailableResourceFinder;
    }

    protected InstantiatorFactory getInstantiatorFactory() {
        return this.instantiatorFactory;
    }

    @Override
    protected RepositoryContentDescriptorInternal createRepositoryDescriptor() {
        return new DefaultMavenRepositoryContentDescriptor();
    }

    private static class MavenMetadataSources
    implements MavenArtifactRepository.MetadataSources {
        boolean gradleMetadata;
        boolean mavenPom;
        boolean artifact;

        private MavenMetadataSources() {
        }

        void setDefaults(FeaturePreviews featurePreviews) {
            this.mavenPom();
            if (featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA)) {
                this.gradleMetadata();
            } else {
                this.artifact();
            }
        }

        void reset() {
            this.gradleMetadata = false;
            this.mavenPom = false;
            this.artifact = false;
        }

        List<String> asList() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.gradleMetadata) {
                list.add("gradleMetadata");
            }
            if (this.mavenPom) {
                list.add("mavenPom");
            }
            if (this.artifact) {
                list.add("artifact");
            }
            return list;
        }

        public void gradleMetadata() {
            this.gradleMetadata = true;
        }

        public void mavenPom() {
            this.mavenPom = true;
        }

        public void artifact() {
            this.artifact = true;
        }
    }

    private static class DefaultDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private DefaultDescriber() {
        }

        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

