/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformationOperation
implements RunnableBuildOperation {
    private final Transformation transformation;
    private final TransformationSubject subject;
    private final ExecutionGraphDependenciesResolver dependenciesResolver;
    private TransformationSubject result;

    TransformationOperation(Transformation transformation, TransformationSubject subject, ExecutionGraphDependenciesResolver dependenciesResolver) {
        this.transformation = transformation;
        this.subject = subject;
        this.dependenciesResolver = dependenciesResolver;
    }

    public void run(@Nullable BuildOperationContext context) {
        this.result = this.transformation.transform(this.subject, this.dependenciesResolver);
    }

    public BuildOperationDescriptor.Builder description() {
        String displayName = "Transform " + this.subject.getDisplayName() + " with " + this.transformation.getDisplayName();
        return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).operationType(BuildOperationCategory.UNCATEGORIZED);
    }

    @Nullable
    public Throwable getFailure() {
        return this.result.getFailure();
    }

    @Nullable
    public List<File> getResult() {
        return this.result.getFiles();
    }
}

