/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import org.simpleframework.transport.PacketException;
import org.simpleframework.transport.Recycler;

class PacketManager
implements Recycler {
    private Queue queue = new Queue();
    private int allow;
    private int size;

    public PacketManager() {
        this(3);
    }

    public PacketManager(int allow) {
        this(allow, 4096);
    }

    public PacketManager(int allow, int size) {
        this.allow = allow;
        this.size = size;
    }

    public ByteBuffer allocate() throws PacketException {
        ByteBuffer next = (ByteBuffer)this.queue.poll();
        if (next != null) {
            return next;
        }
        return this.create();
    }

    private ByteBuffer create() throws PacketException {
        if (this.allow-- >= 0) {
            return this.build();
        }
        try {
            return (ByteBuffer)this.queue.take();
        }
        catch (Exception e) {
            throw new PacketException("Thread interrupt", e);
        }
    }

    public void recycle(ByteBuffer buffer) {
        buffer.clear();
        this.queue.offer(buffer);
    }

    private ByteBuffer build() {
        try {
            return ByteBuffer.allocateDirect(this.size);
        }
        catch (Throwable e) {
            return ByteBuffer.allocate(this.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Queue
    extends LinkedBlockingQueue<ByteBuffer> {
    }
}

