/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.PatternFilterableFileTree;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public abstract class AbstractSingletonFileTree
implements SingletonFileTree,
PatternFilterableFileTree {
    private final PatternSet patterns;

    protected AbstractSingletonFileTree(PatternSet patterns) {
        this.patterns = patterns;
    }

    protected abstract FileVisitDetails createFileVisitDetails();

    @Override
    public void visit(FileVisitor visitor) {
        FileVisitDetails fileVisitDetails = this.createFileVisitDetails();
        if (this.patterns.isEmpty() || this.patterns.getAsSpec().isSatisfiedBy((Object)fileVisitDetails)) {
            visitor.visitFile(fileVisitDetails);
        }
    }

    @Override
    public PatternSet getPatterns() {
        return this.patterns;
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    protected PatternSet filterPatternSet(PatternFilterable patterns) {
        PatternSet patternSet = this.patterns.intersect();
        patternSet.copyFrom(patterns);
        return patternSet;
    }
}

