/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.AbstractArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactsAtRepositoryKey;
import org.gradle.util.BuildCommencedTimeProvider;

public class InMemoryModuleArtifactsCache
extends AbstractArtifactsCache {
    private final Map<ArtifactsAtRepositoryKey, AbstractArtifactsCache.ModuleArtifactsCacheEntry> inMemoryCache = Maps.newConcurrentMap();
    private final AbstractArtifactsCache delegate;

    public InMemoryModuleArtifactsCache(BuildCommencedTimeProvider timeProvider) {
        super(timeProvider);
        this.delegate = null;
    }

    public InMemoryModuleArtifactsCache(BuildCommencedTimeProvider timeProvider, AbstractArtifactsCache delegate) {
        super(timeProvider);
        this.delegate = delegate;
    }

    @Override
    protected void store(ArtifactsAtRepositoryKey key, AbstractArtifactsCache.ModuleArtifactsCacheEntry entry) {
        this.inMemoryCache.put(key, entry);
        if (this.delegate != null) {
            this.delegate.store(key, entry);
        }
    }

    @Override
    protected AbstractArtifactsCache.ModuleArtifactsCacheEntry get(ArtifactsAtRepositoryKey key) {
        AbstractArtifactsCache.ModuleArtifactsCacheEntry entry = this.inMemoryCache.get(key);
        if (entry == null && this.delegate != null && (entry = this.delegate.get(key)) != null) {
            this.inMemoryCache.put(key, entry);
        }
        return entry;
    }
}

