/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import groovy.lang.GroovyObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.inspect.ValidationProblemCollector;
import org.gradle.model.internal.type.ModelType;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class NamedObjectInstantiator {
    public static final NamedObjectInstantiator INSTANCE = new NamedObjectInstantiator();
    private static final Type OBJECT = Type.getType(Object.class);
    private static final Type STRING = Type.getType(String.class);
    private static final Type CLASS_GENERATING_LOADER = Type.getType(ClassGeneratingLoader.class);
    private static final Type MANAGED = Type.getType(Managed.class);
    private static final String[] INTERFACES_FOR_ABSTRACT_CLASS = new String[]{MANAGED.getInternalName()};
    private static final String RETURN_VOID = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING, (Type[])new Type[0]);
    private static final String RETURN_VOID_FROM_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING});
    private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor((Type)OBJECT, (Type[])new Type[]{STRING});
    private static final String NAME_FIELD = "__name__";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final Factory<LoadingCache<Class<?>, LoadingCache<String, Object>>> cacheFactory = new Factory<LoadingCache<Class<?>, LoadingCache<String, Object>>>(){

        public LoadingCache<Class<?>, LoadingCache<String, Object>> create() {
            return NamedObjectInstantiator.this.newValuesCache();
        }
    };
    private final LoadingCache<Class<?>, LoadingCache<String, Object>> leakyValues = this.newValuesCache();

    private LoadingCache<Class<?>, LoadingCache<String, Object>> newValuesCache() {
        return CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, LoadingCache<String, Object>>(){

            public LoadingCache<String, Object> load(Class<?> type) {
                return CacheBuilder.newBuilder().build((CacheLoader)NamedObjectInstantiator.this.loaderFor(type));
            }
        });
    }

    private LoadingCache<Class<?>, LoadingCache<String, Object>> getCacheScope(Class<?> type) {
        ClassLoader classLoader = type.getClassLoader();
        if (classLoader instanceof VisitableURLClassLoader) {
            return (LoadingCache)((VisitableURLClassLoader)classLoader).getUserData(VisitableURLClassLoader.UserData.NAMED_OBJECT_INSTANTIATOR, this.cacheFactory);
        }
        return this.leakyValues;
    }

    public <T extends Named> T named(Class<T> type, String name) throws ObjectInstantiationException {
        try {
            return (T)((Named)type.cast(((LoadingCache)this.getCacheScope(type).getUnchecked(type)).getUnchecked((Object)name)));
        }
        catch (UncheckedExecutionException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
    }

    private ClassGeneratingLoader loaderFor(Class<?> publicClass) {
        String[] interfaces;
        Type superClass;
        FormattingValidationProblemCollector problemCollector = new FormattingValidationProblemCollector("Named implementation class", ModelType.of(publicClass));
        this.visitFields(publicClass, problemCollector);
        if (problemCollector.hasProblems()) {
            throw new GradleException(problemCollector.format());
        }
        AsmClassGenerator generator = new AsmClassGenerator(publicClass, "$Impl");
        Type implementationType = generator.getGeneratedType();
        ClassWriter visitor = generator.getVisitor();
        Type publicType = Type.getType(publicClass);
        if (publicClass.isInterface()) {
            superClass = OBJECT;
            interfaces = new String[]{publicType.getInternalName(), MANAGED.getInternalName()};
        } else {
            superClass = publicType;
            interfaces = INTERFACES_FOR_ABSTRACT_CLASS;
        }
        visitor.visit(49, 4097, implementationType.getInternalName(), null, superClass.getInternalName(), interfaces);
        visitor.visitField(2, NAME_FIELD, STRING.getDescriptor(), null, null);
        MethodVisitor methodVisitor = visitor.visitMethod(1, CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, superClass.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID, false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "getName", RETURN_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "toString", RETURN_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, implementationType.getInternalName(), NAME_FIELD, STRING.getDescriptor());
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        visitor.visitEnd();
        generator.define();
        generator = new AsmClassGenerator(publicClass, "$Factory");
        visitor = generator.getVisitor();
        visitor.visit(49, 4097, generator.getGeneratedType().getInternalName(), null, CLASS_GENERATING_LOADER.getInternalName(), EMPTY_STRINGS);
        methodVisitor = visitor.visitMethod(1, CONSTRUCTOR_NAME, RETURN_VOID, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, CLASS_GENERATING_LOADER.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID, false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = visitor.visitMethod(1, "load", RETURN_OBJECT_FROM_STRING, null, EMPTY_STRINGS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, implementationType.getInternalName());
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, implementationType.getInternalName(), CONSTRUCTOR_NAME, RETURN_VOID_FROM_STRING, false);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        visitor.visitEnd();
        Class factoryClass = generator.define();
        try {
            return (ClassGeneratingLoader)((Object)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void visitFields(Class<?> type, ValidationProblemCollector collector) {
        if (type.equals(Object.class)) {
            return;
        }
        if (type.getSuperclass() != null) {
            this.visitFields(type.getSuperclass(), collector);
        }
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || GroovyObject.class.isAssignableFrom(type) && field.getName().equals("metaClass")) continue;
            collector.add(field, "A Named implementation class must not define any instance fields.");
        }
    }

    protected static abstract class ClassGeneratingLoader
    extends CacheLoader<String, Object> {
        protected ClassGeneratingLoader() {
        }

        public abstract Object load(String var1);
    }

    public static interface Managed {
    }
}

