/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;

@NonNullApi
public class GetOutputFilesVisitor
extends PropertyVisitor.Adapter {
    private final List<OutputFilePropertySpec> specs = Lists.newArrayList();
    private final String ownerDisplayName;
    private final FileCollectionFactory fileCollectionFactory;
    private ImmutableSortedSet<OutputFilePropertySpec> fileProperties;
    private boolean hasDeclaredOutputs;

    public GetOutputFilesVisitor(String ownerDisplayName, FileCollectionFactory fileCollectionFactory) {
        this.ownerDisplayName = ownerDisplayName;
        this.fileCollectionFactory = fileCollectionFactory;
    }

    @Override
    public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
        this.hasDeclaredOutputs = true;
        FileParameterUtils.resolveOutputFilePropertySpecs(this.ownerDisplayName, propertyName, value, filePropertyType, this.fileCollectionFactory, new Consumer<OutputFilePropertySpec>(){

            @Override
            public void accept(OutputFilePropertySpec outputFilePropertySpec) {
                GetOutputFilesVisitor.this.specs.add(outputFilePropertySpec);
            }
        });
    }

    public ImmutableSortedSet<OutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            this.fileProperties = FileParameterUtils.collectFileProperties("output", this.specs.iterator());
        }
        return this.fileProperties;
    }

    public boolean hasDeclaredOutputs() {
        return this.hasDeclaredOutputs;
    }
}

