/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.util.TextUtil;

public class TemplateValue {
    private final String value;

    public TemplateValue(String value) {
        this.value = value;
    }

    public String getGroovyComment() {
        return this.value.replace("\\", "\\\\");
    }

    public String getGroovyString() {
        StringBuilder result = new StringBuilder();
        block9: for (int i = 0; i < this.value.length(); ++i) {
            char ch = this.value.charAt(i);
            switch (ch) {
                case '\\': {
                    result.append('\\').append('\\');
                    continue block9;
                }
                case '\'': {
                    result.append('\\').append('\'');
                    continue block9;
                }
                case '\n': {
                    result.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    result.append('\\').append('r');
                    continue block9;
                }
                case '\t': {
                    result.append('\\').append('t');
                    continue block9;
                }
                case '\f': {
                    result.append('\\').append('f');
                    continue block9;
                }
                case '\b': {
                    result.append('\\').append('b');
                    continue block9;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    public String getStatement() {
        if (this.value.isEmpty()) {
            return "";
        }
        return this.value + TextUtil.getPlatformLineSeparator();
    }

    public String getJavaStatement() {
        if (this.value.isEmpty()) {
            return "";
        }
        return this.value + ";" + TextUtil.getPlatformLineSeparator();
    }

    public String toString() {
        return ">>>" + this.value + "<<<";
    }
}

