/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.impl.AbstractArraySnapshot;

class ArrayValueSnapshot
extends AbstractArraySnapshot<ValueSnapshot>
implements ValueSnapshot {
    public static final ArrayValueSnapshot EMPTY = new ArrayValueSnapshot((ImmutableList<ValueSnapshot>)ImmutableList.of());

    public ArrayValueSnapshot(ImmutableList<ValueSnapshot> elements) {
        super(elements);
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isEqualArrayValueSnapshot(other)) {
            return this;
        }
        return other;
    }

    private boolean isEqualArrayValueSnapshot(ValueSnapshot other) {
        if (other instanceof ArrayValueSnapshot) {
            ArrayValueSnapshot otherArray = (ArrayValueSnapshot)other;
            if (this.elements.equals((Object)otherArray.elements)) {
                return true;
            }
        }
        return false;
    }
}

