/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformResolveMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependencies;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PotentialEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.SelectedByVariantMatchingConfigurationMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private static final Spec<EdgeState> TRANSITIVE_EDGES = new Spec<EdgeState>(){

        public boolean isSatisfiedBy(EdgeState edge) {
            return edge.isTransitive();
        }
    };
    private final Long resultId;
    private final ComponentState component;
    private final List<EdgeState> incomingEdges = Lists.newArrayList();
    private final List<EdgeState> outgoingEdges = Lists.newArrayList();
    private final ResolvedConfigurationIdentifier id;
    private final ConfigurationMetadata metaData;
    private final ResolveState resolveState;
    private final boolean isTransitive;
    private final boolean selectedByVariantAwareResolution;
    ModuleExclusion previousTraversalExclusions;
    private List<EdgeState> virtualEdges;
    private boolean queued;
    private boolean evicted;
    private Set<ModuleIdentifier> upcomingNoLongerPendingConstraints;
    private boolean virtualPlatformNeedsRefresh;

    public NodeState(Long resultId, ResolvedConfigurationIdentifier id, ComponentState component, ResolveState resolveState, ConfigurationMetadata md) {
        this.resultId = resultId;
        this.id = id;
        this.component = component;
        this.resolveState = resolveState;
        this.metaData = md;
        this.isTransitive = this.metaData.isTransitive();
        this.selectedByVariantAwareResolution = md instanceof SelectedByVariantMatchingConfigurationMetadata;
        component.addConfiguration(this);
    }

    boolean enqueue() {
        if (this.queued) {
            return false;
        }
        this.queued = true;
        return true;
    }

    NodeState dequeue() {
        this.queued = false;
        return this;
    }

    @Override
    public ComponentState getComponent() {
        return this.component;
    }

    @Override
    public Long getNodeId() {
        return this.resultId;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ResolvedConfigurationIdentifier getResolvedConfigurationId() {
        return this.id;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public List<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public ConfigurationMetadata getMetadata() {
        return this.metaData;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.metaData instanceof LocalConfigurationMetadata) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.isTransitive()) continue;
                return ((LocalConfigurationMetadata)this.metaData).getFiles();
            }
        }
        return Collections.emptySet();
    }

    public String toString() {
        return String.format("%s(%s)", this.component, this.id.getConfiguration());
    }

    public String getSimpleName() {
        return this.component.getId().toString();
    }

    public String getNameWithVariant() {
        return this.component.getId() + " variant " + this.id.getConfiguration();
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    public void visitOutgoingDependencies(Collection<EdgeState> discoveredEdges) {
        if (!this.component.isSelected()) {
            LOGGER.debug("version for {} is not selected. ignoring.", (Object)this);
            return;
        }
        List<EdgeState> transitiveIncoming = this.getTransitiveIncomingEdges();
        if (transitiveIncoming.isEmpty() && !this.isRoot()) {
            this.handleNonTransitiveNode(discoveredEdges);
            return;
        }
        ModuleExclusion resolutionFilter = this.getModuleResolutionFilter(this.incomingEdges);
        if (!this.isVirtualPlatformNeedsRefresh() && this.previousTraversalExclusions != null && this.previousTraversalExclusions.excludesSameModulesAs(resolutionFilter)) {
            if (this.hasNewConstraints()) {
                this.visitAdditionalConstraints(discoveredEdges);
            } else {
                LOGGER.debug("Changed edges for {} selects same versions as previous traversal. ignoring", (Object)this);
            }
            this.previousTraversalExclusions = resolutionFilter;
            return;
        }
        if (this.previousTraversalExclusions != null) {
            this.removeOutgoingEdges();
        }
        this.visitDependencies(resolutionFilter, discoveredEdges);
        this.visitOwners(discoveredEdges);
    }

    private boolean hasNewConstraints() {
        return this.upcomingNoLongerPendingConstraints != null;
    }

    private boolean isVirtualPlatformNeedsRefresh() {
        return this.virtualPlatformNeedsRefresh;
    }

    private void handleNonTransitiveNode(Collection<EdgeState> discoveredEdges) {
        if (this.previousTraversalExclusions != null) {
            this.removeOutgoingEdges();
        }
        if (!this.incomingEdges.isEmpty()) {
            LOGGER.debug("{} has no transitive incoming edges. ignoring outgoing edges.", (Object)this);
            this.visitOwners(discoveredEdges);
        } else {
            LOGGER.debug("{} has no incoming edges. ignoring.", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitDependencies(ModuleExclusion resolutionFilter, Collection<EdgeState> discoveredEdges) {
        PendingDependenciesVisitor pendingDepsVisitor = this.resolveState.newPendingDependenciesVisitor();
        try {
            for (DependencyMetadata dependencyMetadata : this.metaData.getDependencies()) {
                DependencyState dependencyState = new DependencyState(dependencyMetadata, this.resolveState.getComponentSelectorConverter());
                if (this.isExcluded(resolutionFilter, dependencyState) || pendingDepsVisitor.maybeAddAsPendingDependency(this, dependencyState = NodeState.maybeSubstitute(dependencyState, this.resolveState.getDependencySubstitutionApplicator()))) continue;
                this.createAndLinkEdgeState(dependencyState, discoveredEdges, resolutionFilter);
            }
            this.previousTraversalExclusions = resolutionFilter;
        }
        finally {
            pendingDepsVisitor.complete();
        }
    }

    private void createAndLinkEdgeState(DependencyState dependencyState, Collection<EdgeState> discoveredEdges, ModuleExclusion resolutionFilter) {
        EdgeState dependencyEdge = new EdgeState(this, dependencyState, resolutionFilter, this.resolveState);
        this.outgoingEdges.add(dependencyEdge);
        discoveredEdges.add(dependencyEdge);
        dependencyEdge.getSelector().use();
    }

    private void visitAdditionalConstraints(Collection<EdgeState> discoveredEdges) {
        for (DependencyMetadata dependencyMetadata : this.metaData.getDependencies()) {
            DependencyState dependencyState;
            if (!dependencyMetadata.isConstraint() || !this.upcomingNoLongerPendingConstraints.contains((dependencyState = new DependencyState(dependencyMetadata, this.resolveState.getComponentSelectorConverter())).getModuleIdentifier())) continue;
            dependencyState = NodeState.maybeSubstitute(dependencyState, this.resolveState.getDependencySubstitutionApplicator());
            this.createAndLinkEdgeState(dependencyState, discoveredEdges, this.previousTraversalExclusions);
        }
        this.upcomingNoLongerPendingConstraints = null;
    }

    private void visitOwners(Collection<EdgeState> discoveredEdges) {
        ImmutableList<? extends ComponentIdentifier> owners = this.component.getMetadata().getPlatformOwners();
        if (!owners.isEmpty()) {
            PendingDependenciesVisitor visitor = this.resolveState.newPendingDependenciesVisitor();
            for (ComponentIdentifier owner : owners) {
                if (!(owner instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier platformId = (ModuleComponentIdentifier)owner;
                ModuleComponentSelector cs = DefaultModuleComponentSelector.newSelector(platformId.getModuleIdentifier(), platformId.getVersion());
                this.addPlatformEdges(discoveredEdges, platformId, cs);
                visitor.markNotPending(platformId.getModuleIdentifier());
            }
            visitor.complete();
        }
    }

    private void addPlatformEdges(Collection<EdgeState> discoveredEdges, ModuleComponentIdentifier platformComponentIdentifier, ModuleComponentSelector platformSelector) {
        PotentialEdge potentialEdge = PotentialEdge.of(this.resolveState, this, platformComponentIdentifier, platformSelector, (ComponentIdentifier)platformComponentIdentifier);
        ComponentResolveMetadata metadata = potentialEdge.metadata;
        VirtualPlatformState virtualPlatformState = null;
        if (metadata == null || metadata instanceof LenientPlatformResolveMetadata) {
            virtualPlatformState = potentialEdge.component.getModule().getPlatformState();
            virtualPlatformState.participatingModule(this.component.getModule());
        }
        if (metadata == null) {
            metadata = new LenientPlatformResolveMetadata(platformComponentIdentifier, potentialEdge.toModuleVersionId, virtualPlatformState, this, this.resolveState);
            potentialEdge.component.setMetadata(metadata);
            potentialEdge.component.getModule().maybeCreateVirtualMetadata(this.resolveState);
        }
        if (this.virtualEdges == null) {
            this.virtualEdges = Lists.newArrayList();
        }
        EdgeState edge = potentialEdge.edge;
        this.virtualEdges.add(edge);
        discoveredEdges.add(edge);
        edge.getSelector().use();
    }

    static DependencyState maybeSubstitute(DependencyState dependencyState, DependencySubstitutionApplicator dependencySubstitutionApplicator) {
        DependencySubstitutionApplicator.SubstitutionResult substitutionResult = dependencySubstitutionApplicator.apply(dependencyState.getDependency());
        if (substitutionResult.hasFailure()) {
            dependencyState.failure = new ModuleVersionResolveException(dependencyState.getRequested(), substitutionResult.getFailure());
            return dependencyState;
        }
        DependencySubstitutionInternal details = substitutionResult.getResult();
        if (details != null && details.isUpdated()) {
            return dependencyState.withTarget(details.getTarget(), details.getRuleDescriptors());
        }
        return dependencyState;
    }

    private List<EdgeState> getTransitiveIncomingEdges() {
        if (this.isRoot()) {
            return this.incomingEdges;
        }
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (incomingEdge.isTransitive()) continue;
            return CollectionUtils.filter(this.incomingEdges, TRANSITIVE_EDGES);
        }
        return this.incomingEdges;
    }

    private boolean isExcluded(ModuleExclusion selector, DependencyState dependencyState) {
        DependencyMetadata dependency = dependencyState.getDependency();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (selector == ModuleExclusions.excludeNone()) {
            return false;
        }
        ModuleIdentifier targetModuleId = dependencyState.getModuleIdentifier();
        if (selector.excludeModule(targetModuleId)) {
            LOGGER.debug("{} is excluded from {}.", (Object)targetModuleId, (Object)this);
            return true;
        }
        return false;
    }

    public void addIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.add(dependencyEdge);
        this.resolveState.onMoreSelected(this);
    }

    public void removeIncomingEdge(EdgeState dependencyEdge) {
        this.incomingEdges.remove(dependencyEdge);
        this.resolveState.onFewerSelected(this);
    }

    @Override
    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    public void evict() {
        this.evicted = true;
        this.restartIncomingEdges();
    }

    public boolean shouldIncludedInGraphResult() {
        return this.isSelected() && !this.component.getModule().isVirtualPlatform();
    }

    private ModuleExclusion getModuleResolutionFilter(List<EdgeState> incomingEdges) {
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        ModuleExclusion nodeExclusions = moduleExclusions.excludeAny(this.metaData.getExcludes());
        if (incomingEdges.isEmpty()) {
            return nodeExclusions;
        }
        ModuleExclusion edgeExclusions = null;
        for (EdgeState dependencyEdge : incomingEdges) {
            if (dependencyEdge.isTransitive()) {
                edgeExclusions = this.excludedByBoth(edgeExclusions, dependencyEdge.getExclusions());
                continue;
            }
            if (!dependencyEdge.getDependencyMetadata().isConstraint()) continue;
            ModuleExclusion constraintExclusions = dependencyEdge.getEdgeExclusions();
            nodeExclusions = this.excludedByEither(nodeExclusions, constraintExclusions);
        }
        return this.excludedByEither(edgeExclusions, nodeExclusions);
    }

    private ModuleExclusion excludedByBoth(ModuleExclusion one, ModuleExclusion two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return this.resolveState.getModuleExclusions().union(one, two);
    }

    private ModuleExclusion excludedByEither(ModuleExclusion one, ModuleExclusion two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        return this.resolveState.getModuleExclusions().intersect(one, two);
    }

    private void removeOutgoingEdges() {
        if (!this.outgoingEdges.isEmpty()) {
            for (EdgeState outgoingDependency : this.outgoingEdges) {
                outgoingDependency.removeFromTargetConfigurations();
                outgoingDependency.getSelector().release();
                outgoingDependency.maybeDecreaseHardEdgeCount();
            }
        }
        this.outgoingEdges.clear();
        if (this.virtualEdges != null) {
            for (EdgeState outgoingDependency : this.virtualEdges) {
                outgoingDependency.removeFromTargetConfigurations();
                outgoingDependency.getSelector().release();
            }
        }
        this.virtualEdges = null;
        this.previousTraversalExclusions = null;
        this.upcomingNoLongerPendingConstraints = null;
        this.virtualPlatformNeedsRefresh = false;
    }

    public void restart(ComponentState selected) {
        if (this.component == selected) {
            if (!this.evicted) {
                this.resolveState.onMoreSelected(this);
            }
        } else if (!this.incomingEdges.isEmpty()) {
            this.restartIncomingEdges();
        }
    }

    private void restartIncomingEdges() {
        if (this.incomingEdges.size() == 1) {
            EdgeState singleEdge = this.incomingEdges.get(0);
            singleEdge.restart();
        } else {
            for (EdgeState dependency : new ArrayList<EdgeState>(this.incomingEdges)) {
                dependency.restart();
            }
        }
        this.incomingEdges.clear();
    }

    public void deselect() {
        this.removeOutgoingEdges();
    }

    void prepareForConstraintNoLongerPending(ModuleIdentifier moduleIdentifier) {
        if (this.upcomingNoLongerPendingConstraints == null) {
            this.upcomingNoLongerPendingConstraints = Sets.newHashSet();
        }
        this.upcomingNoLongerPendingConstraints.add(moduleIdentifier);
        this.resolveState.onFewerSelected(this);
    }

    void markForVirtualPlatformRefresh() {
        assert (this.component.getModule().isVirtualPlatform());
        this.virtualPlatformNeedsRefresh = true;
        this.resolveState.onFewerSelected(this);
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.resolveState.getAttributesFactory();
    }

    public void clearConstraintEdges(PendingDependencies pendingDependencies) {
        for (EdgeState incomingEdge : this.incomingEdges) {
            assert (incomingEdge.getDependencyMetadata().isConstraint());
            incomingEdge.getSelector().release();
            NodeState from = incomingEdge.getFrom();
            from.getOutgoingEdges().remove(incomingEdge);
            pendingDependencies.addNode(from);
        }
        this.incomingEdges.clear();
    }

    void forEachCapability(Action<? super Capability> action) {
        List capabilities = this.metaData.getCapabilities().getCapabilities();
        if (capabilities.isEmpty() && this.component.hasMoreThanOneSelectedNodeUsingVariantAwareResolution()) {
            action.execute((Object)this.component.getImplicitCapability());
        } else if (!capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                action.execute((Object)capability);
            }
        }
    }

    public Capability findCapability(String group, String name) {
        Capability onComponent = this.component.findCapability(group, name);
        if (onComponent != null) {
            return onComponent;
        }
        List capabilities = this.metaData.getCapabilities().getCapabilities();
        if (!capabilities.isEmpty()) {
            for (Capability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    public boolean isAttachedToVirtualPlatform() {
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (!(incomingEdge.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata)) continue;
            return true;
        }
        return false;
    }

    boolean hasShadowedCapability() {
        for (Capability capability : this.metaData.getCapabilities().getCapabilities()) {
            if (!(capability instanceof ShadowedCapability)) continue;
            return true;
        }
        return false;
    }

    boolean isSelectedByVariantAwareResolution() {
        return this.selectedByVariantAwareResolution && this.isSelected();
    }
}

