/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.TransformationChain;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.AttributeMatcher;

public class ConsumerProvidedVariantFinder {
    private final VariantTransformRegistry variantTransforms;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final Map<AttributeContainer, AttributeSpecificCache> attributeSpecificCache = Maps.newConcurrentMap();

    public ConsumerProvidedVariantFinder(VariantTransformRegistry variantTransforms, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory) {
        this.variantTransforms = variantTransforms;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
    }

    public void collectConsumerVariants(AttributeContainerInternal actual, AttributeContainerInternal requested, ConsumerVariantMatchResult result) {
        AttributeSpecificCache toCache = this.getCache((AttributeContainer)requested);
        ConsumerVariantMatchResult cachedResult = (ConsumerVariantMatchResult)toCache.transforms.get(actual);
        if (cachedResult == null) {
            cachedResult = new ConsumerVariantMatchResult();
            this.findProducersFor(actual, requested, cachedResult);
            toCache.transforms.put(actual, cachedResult);
        }
        cachedResult.applyTo(result);
    }

    private void findProducersFor(AttributeContainerInternal actual, AttributeContainerInternal requested, ConsumerVariantMatchResult result) {
        ArrayList<ArtifactTransformRegistration> candidates = new ArrayList<ArtifactTransformRegistration>();
        for (ArtifactTransformRegistration registration : this.variantTransforms.getTransforms()) {
            ImmutableAttributes variantAttributes;
            if (!this.matchAttributes(registration.getTo(), requested)) continue;
            if (this.matchAttributes(actual, registration.getFrom()) && this.matchAttributes((AttributeContainerInternal)(variantAttributes = this.attributesFactory.concat(actual.asImmutable(), registration.getTo().asImmutable())), requested)) {
                result.matched(variantAttributes, registration.getTransformationStep(), 1);
            }
            candidates.add(registration);
        }
        if (result.hasMatches()) {
            return;
        }
        for (ArtifactTransformRegistration candidate : candidates) {
            ConsumerVariantMatchResult inputVariants = new ConsumerVariantMatchResult();
            AttributeContainerInternal requestedPrevious = this.computeRequestedAttributes(requested, candidate);
            this.collectConsumerVariants(actual, requestedPrevious, inputVariants);
            if (!inputVariants.hasMatches()) continue;
            for (ConsumerVariantMatchResult.ConsumerVariant inputVariant : inputVariants.getMatches()) {
                ImmutableAttributes variantAttributes = this.attributesFactory.concat(inputVariant.attributes.asImmutable(), candidate.getTo().asImmutable());
                TransformationChain transformation = new TransformationChain(inputVariant.transformation, candidate.getTransformationStep());
                result.matched(variantAttributes, transformation, inputVariant.depth + 1);
            }
        }
    }

    private AttributeContainerInternal computeRequestedAttributes(AttributeContainerInternal result, ArtifactTransformRegistration transform) {
        return this.attributesFactory.concat(result.asImmutable(), transform.getFrom().asImmutable()).asImmutable();
    }

    private AttributeSpecificCache getCache(AttributeContainer attributes) {
        AttributeSpecificCache cache = this.attributeSpecificCache.get(attributes);
        if (cache == null) {
            cache = new AttributeSpecificCache();
            this.attributeSpecificCache.put(attributes, cache);
        }
        return cache;
    }

    private boolean matchAttributes(AttributeContainerInternal actual, AttributeContainerInternal requested) {
        AttributeMatcher schemaToMatchOn = this.schema.matcher();
        Map cache = this.getCache((AttributeContainer)requested).ignoreExtraActual;
        Boolean match = (Boolean)cache.get(actual);
        if (match == null) {
            match = schemaToMatchOn.isMatching(actual, requested);
            cache.put(actual, match);
        }
        return match;
    }

    private static class AttributeSpecificCache {
        private final Map<AttributeContainer, Boolean> ignoreExtraActual = Maps.newConcurrentMap();
        private final Map<AttributeContainer, ConsumerVariantMatchResult> transforms = Maps.newConcurrentMap();

        private AttributeSpecificCache() {
        }
    }
}

