/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.DefaultBuildRequestContext;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.logging.sink.ConsoleStateUtil;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.launcher.cli.action.ExecuteBuildAction;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class RunBuildAction
implements Runnable {
    private final BuildActionExecuter<BuildActionParameters> executer;
    private final StartParameterInternal startParameter;
    private final BuildClientMetaData clientMetaData;
    private final long startTime;
    private final BuildActionParameters buildActionParameters;
    private final ServiceRegistry sharedServices;
    private final Stoppable stoppable;

    public RunBuildAction(BuildActionExecuter<BuildActionParameters> executer, StartParameterInternal startParameter, BuildClientMetaData clientMetaData, long startTime, BuildActionParameters buildActionParameters, ServiceRegistry sharedServices, Stoppable stoppable) {
        this.executer = executer;
        this.startParameter = startParameter;
        this.clientMetaData = clientMetaData;
        this.startTime = startTime;
        this.buildActionParameters = buildActionParameters;
        this.sharedServices = sharedServices;
        this.stoppable = stoppable;
    }

    @Override
    public void run() {
        try {
            BuildActionResult result = this.executer.execute(new ExecuteBuildAction(this.startParameter), (BuildRequestContext)new DefaultBuildRequestContext((BuildRequestMetaData)new DefaultBuildRequestMetaData(this.clientMetaData, this.startTime, ConsoleStateUtil.isInteractive()), (BuildCancellationToken)new DefaultBuildCancellationToken(), (BuildEventConsumer)new NoOpBuildEventConsumer()), this.buildActionParameters, this.sharedServices);
            if (result.hasFailure()) {
                throw new ReportedException();
            }
        }
        finally {
            if (this.stoppable != null) {
                this.stoppable.stop();
            }
        }
    }
}

