/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskFingerprinter;
import org.gradle.api.internal.tasks.properties.FilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public class ResolveBeforeExecutionOutputsTaskExecuter
implements TaskExecuter {
    private final TaskFingerprinter taskFingerprinter;
    private final TaskExecuter delegate;

    public ResolveBeforeExecutionOutputsTaskExecuter(TaskFingerprinter taskFingerprinter, TaskExecuter delegate) {
        this.taskFingerprinter = taskFingerprinter;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, final TaskExecutionContext context) {
        ImmutableSortedSet<OutputFilePropertySpec> outputFilePropertySpecs = context.getTaskProperties().getOutputFileProperties();
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsBeforeExecution = this.taskFingerprinter.fingerprintTaskFiles(task, (SortedSet<? extends FilePropertySpec>)outputFilePropertySpecs);
        context.setOutputFilesBeforeExecution(outputsBeforeExecution);
        AfterPreviousExecutionState afterPreviousExecutionState = context.getAfterPreviousExecution();
        ImmutableSortedMap outputsAfterPreviousExecution = afterPreviousExecutionState != null ? afterPreviousExecutionState.getOutputFileProperties() : ImmutableSortedMap.of();
        OverlappingOutputs.detect((ImmutableSortedMap<String, FileCollectionFingerprint>)outputsAfterPreviousExecution, outputsBeforeExecution).ifPresent(new Consumer<OverlappingOutputs>(){

            @Override
            public void accept(OverlappingOutputs overlappingOutputs) {
                context.setOverlappingOutputs(overlappingOutputs);
            }
        });
        return this.delegate.execute(task, state, context);
    }
}

