/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/builtins/UnsignedTypes;", "", "()V", "arrayClassIdToUnsignedClassId", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lkotlin/collections/HashMap;", "arrayClassesShortNames", "", "Lorg/jetbrains/kotlin/name/Name;", "unsignedClassIdToArrayClassId", "unsignedTypeNames", "getUnsignedArrayClassIdByUnsignedClassId", "arrayClassId", "getUnsignedClassIdByArrayClassId", "isShortNameOfUnsignedArray", "", "name", "isUnsignedClass", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "isUnsignedType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
public final class UnsignedTypes {
    private static final Set<Name> unsignedTypeNames;
    private static final HashMap<ClassId, ClassId> arrayClassIdToUnsignedClassId;
    private static final HashMap<ClassId, ClassId> unsignedClassIdToArrayClassId;
    private static final Set<Name> arrayClassesShortNames;
    public static final UnsignedTypes INSTANCE;

    public final boolean isShortNameOfUnsignedArray(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return arrayClassesShortNames.contains(name);
    }

    @Nullable
    public final ClassId getUnsignedClassIdByArrayClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkParameterIsNotNull((Object)arrayClassId, (String)"arrayClassId");
        return arrayClassIdToUnsignedClassId.get(arrayClassId);
    }

    @Nullable
    public final ClassId getUnsignedArrayClassIdByUnsignedClassId(@NotNull ClassId arrayClassId) {
        Intrinsics.checkParameterIsNotNull((Object)arrayClassId, (String)"arrayClassId");
        return unsignedClassIdToArrayClassId.get(arrayClassId);
    }

    public final boolean isUnsignedType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (TypeUtils.noExpectedType(type2)) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"type.constructor.declara\u2026escriptor ?: return false");
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        return this.isUnsignedClass(descriptor2);
    }

    public final boolean isUnsignedClass(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        return container2 instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)container2).getFqName(), (Object)KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME) && unsignedTypeNames.contains(descriptor2.getName());
    }

    private UnsignedTypes() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        UnsignedType[] unsignedTypeArray;
        Name name;
        Collection collection;
        UnsignedType item$iv$iv;
        void $receiver$iv$iv;
        UnsignedTypes unsignedTypes;
        INSTANCE = unsignedTypes = new UnsignedTypes();
        UnsignedType[] $receiver$iv = UnsignedType.values();
        UnsignedType[] unsignedTypeArray2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        void var4_5 = $receiver$iv$iv;
        int n = ((void)var4_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            item$iv$iv = var4_5[i];
            void var8_13 = item$iv$iv;
            collection = destination$iv$iv;
            name = it.getTypeName();
            collection.add(name);
        }
        unsignedTypeNames = CollectionsKt.toSet((Iterable)((List)unsignedTypeArray));
        arrayClassIdToUnsignedClassId = new HashMap();
        unsignedClassIdToArrayClassId = new HashMap();
        $receiver$iv = UnsignedType.values();
        Collection destination$iv = new LinkedHashSet();
        unsignedTypeArray = $receiver$iv;
        int n2 = unsignedTypeArray.length;
        for (n = 0; n < n2; ++n) {
            void it;
            UnsignedType item$iv;
            item$iv$iv = item$iv = unsignedTypeArray[n];
            collection = destination$iv;
            name = it.getArrayClassId().getShortClassName();
            collection.add(name);
        }
        arrayClassesShortNames = (Set)unsignedTypeArray2;
        for (UnsignedType unsignedType : UnsignedType.values()) {
            Map map2 = arrayClassIdToUnsignedClassId;
            ClassId classId = unsignedType.getArrayClassId();
            ClassId classId2 = unsignedType.getClassId();
            map2.put(classId, classId2);
            map2 = unsignedClassIdToArrayClassId;
            classId = unsignedType.getClassId();
            classId2 = unsignedType.getArrayClassId();
            map2.put(classId, classId2);
        }
    }
}

