/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.kotlin.dsl.execution.Interpreter;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u001a&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u001a \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u001a\u001f\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#H\u0082\b\u001a&\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%*\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0#H\u0082\b\u00a2\u0006\u0002\u0010'\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006("}, d2={"interpreterLogger", "Lorg/slf4j/Logger;", "getInterpreterLogger", "()Lorg/slf4j/Logger;", "classLoaderScopeIdFor", "", "scriptPath", "stage", "locationAwareExceptionFor", "Lorg/gradle/internal/exceptions/LocationAwareException;", "original", "", "scriptClass", "Ljava/lang/Class;", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "locationAwareExceptionHandlingFor", "", "e", "logClassLoadingOf", "", "templateId", "source", "logCompilationOf", "maybeUnwrapInvocationTargetException", "kotlin.jvm.PlatformType", "templateIdFor", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "withContextClassLoader", "classLoader", "Ljava/lang/ClassLoader;", "block", "Lkotlin/Function0;", "withLocationAwareExceptionHandling", "T", "action", "(Lorg/gradle/groovy/scripts/ScriptSource;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "gradle-kotlin-dsl"})
public final class InterpreterKt {
    @NotNull
    private static final Logger interpreterLogger;

    @VisibleForTesting
    @NotNull
    public static final String templateIdFor(@NotNull ProgramTarget programTarget, @NotNull ProgramKind programKind, @NotNull String stage) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)programTarget), (String)"programTarget");
        Intrinsics.checkParameterIsNotNull((Object)((Object)programKind), (String)"programKind");
        Intrinsics.checkParameterIsNotNull((Object)stage, (String)"stage");
        return programTarget.name() + "/" + programKind.name() + "/" + stage;
    }

    private static final String classLoaderScopeIdFor(String scriptPath, String stage) {
        return "kotlin-dsl:" + scriptPath + ':' + stage;
    }

    private static final Void locationAwareExceptionHandlingFor(Throwable e, Class<?> scriptClass, ScriptSource scriptSource) {
        LocationAwareException locationAware;
        Throwable targetException;
        Throwable throwable = targetException = InterpreterKt.maybeUnwrapInvocationTargetException(e);
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"targetException");
        LocationAwareException locationAwareException = locationAware = InterpreterKt.locationAwareExceptionFor(throwable, scriptClass, scriptSource);
        throw locationAwareException != null ? (Throwable)locationAwareException : targetException;
    }

    private static final LocationAwareException locationAwareExceptionFor(Throwable original, Class<?> scriptClass, ScriptSource scriptSource) {
        String scriptClassName = scriptClass.getName();
        String scriptClassNameInnerPrefix = scriptClassName + '$';
        Function1<StackTraceElement, Boolean> scriptStackTraceElement$ = new Function1<StackTraceElement, Boolean>(scriptClassName, scriptClassNameInnerPrefix){
            final /* synthetic */ String $scriptClassName;
            final /* synthetic */ String $scriptClassNameInnerPrefix;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull StackTraceElement element) {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                String string3 = element.getClassName();
                if (string3 == null) return false;
                String $receiver = string2 = string3;
                boolean bl = false;
                if ($receiver.equals(this.$scriptClassName)) return true;
                if (!StringsKt.startsWith$default((String)$receiver, (String)this.$scriptClassNameInnerPrefix, (boolean)false, (int)2, null)) return false;
                return true;
            }
            {
                this.$scriptClassName = string2;
                this.$scriptClassNameInnerPrefix = string3;
                super(1);
            }
        };
        Function1<Throwable, LocationAwareException> inferLocationFrom$ = new Function1<Throwable, LocationAwareException>(scriptStackTraceElement$, original, scriptSource){
            final /* synthetic */ locationAwareExceptionFor.1 $scriptStackTraceElement$1;
            final /* synthetic */ Throwable $original;
            final /* synthetic */ ScriptSource $scriptSource;

            @Nullable
            public final LocationAwareException invoke(@NotNull Throwable exception) {
                while (true) {
                    Throwable cause;
                    StackTraceElement stackTraceElement;
                    Serializable serializable;
                    StackTraceElement[] stackTraceElementArray;
                    block5: {
                        StackTraceElement[] stackTraceElementArray2;
                        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                        if (exception instanceof LocationAwareException) {
                            return (LocationAwareException)exception;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)exception.getStackTrace(), (String)"exception.stackTrace");
                        StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray2 = stackTraceElementArray;
                        int n = stackTraceElementArray3.length;
                        for (int j = 0; j < n; ++j) {
                            StackTraceElement p1 = serializable = stackTraceElementArray3[j];
                            boolean bl = false;
                            if (!this.$scriptStackTraceElement$1.invoke(p1)) continue;
                            stackTraceElement = serializable;
                            break block5;
                        }
                        stackTraceElement = null;
                    }
                    if (stackTraceElement != null) {
                        Integer n;
                        StackTraceElement[] $receiver = stackTraceElementArray = stackTraceElement;
                        boolean bl = false;
                        Integer n2 = $receiver.getLineNumber();
                        ScriptSource scriptSource = this.$scriptSource;
                        serializable = this.$original;
                        int it = ((Number)n2).intValue();
                        boolean bl2 = false;
                        Integer n3 = n = it >= 0 ? n2 : null;
                        ScriptSource scriptSource2 = scriptSource;
                        Serializable serializable2 = serializable;
                        return new LocationAwareException((Throwable)serializable2, scriptSource2, n3);
                    }
                    if (exception.getCause() == null) {
                        return null;
                    }
                    exception = cause;
                }
            }
            {
                this.$scriptStackTraceElement$1 = var1_1;
                this.$original = throwable;
                this.$scriptSource = scriptSource;
                super(1);
            }
        };
        return inferLocationFrom$.invoke(original);
    }

    private static final <T> T withLocationAwareExceptionHandling(@NotNull ScriptSource $receiver, Function0<? extends T> action) {
        Object object;
        int $i$f$withLocationAwareExceptionHandling = 0;
        try {
            object = action.invoke();
        }
        catch (ScriptCompilationException e) {
            throw (Throwable)new LocationAwareException((Throwable)e, $receiver, e.getFirstErrorLine());
        }
        return (T)object;
    }

    private static final Throwable maybeUnwrapInvocationTargetException(Throwable e) {
        return e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void withContextClassLoader(ClassLoader classLoader, Function0<Unit> block) {
        Thread currentThread;
        int $i$f$withContextClassLoader = 0;
        Thread thread = currentThread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread");
        ClassLoader previous = thread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            currentThread.setContextClassLoader(previous);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final void logCompilationOf(String templateId, ScriptSource source) {
        interpreterLogger.debug("Compiling " + templateId + " from " + source.getDisplayName());
    }

    private static final void logClassLoadingOf(String templateId, ScriptSource source) {
        interpreterLogger.debug("Loading " + templateId + " from " + source.getDisplayName());
    }

    @NotNull
    public static final Logger getInterpreterLogger() {
        return interpreterLogger;
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger2 = LoggerFactory.getLogger(Interpreter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"LoggerFactory.getLogger(T::class.java)");
        interpreterLogger = logger2;
    }

    public static final /* synthetic */ Void access$locationAwareExceptionHandlingFor(Throwable e, Class scriptClass, ScriptSource scriptSource) {
        return InterpreterKt.locationAwareExceptionHandlingFor(e, scriptClass, scriptSource);
    }

    public static final /* synthetic */ Object access$withLocationAwareExceptionHandling(ScriptSource $receiver, Function0 action) {
        return InterpreterKt.withLocationAwareExceptionHandling($receiver, action);
    }

    public static final /* synthetic */ void access$withContextClassLoader(ClassLoader classLoader, Function0 block) {
        InterpreterKt.withContextClassLoader(classLoader, (Function0<Unit>)block);
    }

    public static final /* synthetic */ void access$logClassLoadingOf(String templateId, ScriptSource source) {
        InterpreterKt.logClassLoadingOf(templateId, source);
    }

    public static final /* synthetic */ String access$classLoaderScopeIdFor(String scriptPath, String stage) {
        return InterpreterKt.classLoaderScopeIdFor(scriptPath, stage);
    }

    public static final /* synthetic */ void access$logCompilationOf(String templateId, ScriptSource source) {
        InterpreterKt.logCompilationOf(templateId, source);
    }
}

