/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import javax.annotation.Nullable;
import org.gradle.cache.internal.filelock.LockInfo;
import org.gradle.cache.internal.filelock.LockInfoAccess;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateAccess;

public class LockFileAccess {
    private final RandomAccessFile lockFileAccess;
    private final LockStateAccess lockStateAccess;
    private final LockInfoAccess lockInfoAccess;

    public LockFileAccess(File lockFile, LockStateAccess lockStateAccess) throws FileNotFoundException {
        this.lockFileAccess = new RandomAccessFile(lockFile, "rw");
        this.lockStateAccess = lockStateAccess;
        this.lockInfoAccess = new LockInfoAccess(this.lockStateAccess.getRegionEnd());
    }

    public void close() throws IOException {
        this.lockFileAccess.close();
    }

    public void writeLockInfo(int port, long lockId, String pid, String operation) throws IOException {
        LockInfo lockInfo = new LockInfo();
        lockInfo.port = port;
        lockInfo.lockId = lockId;
        lockInfo.pid = pid;
        lockInfo.operation = operation;
        this.lockInfoAccess.writeLockInfo(this.lockFileAccess, lockInfo);
    }

    public LockInfo readLockInfo() throws IOException {
        return this.lockInfoAccess.readLockInfo(this.lockFileAccess);
    }

    public LockState ensureLockState() throws IOException {
        return this.lockStateAccess.ensureLockState(this.lockFileAccess);
    }

    public LockState markClean(LockState lockState) throws IOException {
        LockState newState = lockState.completeUpdate();
        this.lockStateAccess.writeState(this.lockFileAccess, newState);
        return newState;
    }

    public LockState markDirty(LockState lockState) throws IOException {
        LockState newState = lockState.beforeUpdate();
        this.lockStateAccess.writeState(this.lockFileAccess, newState);
        return newState;
    }

    public void clearLockInfo() throws IOException {
        this.lockInfoAccess.clearLockInfo(this.lockFileAccess);
    }

    @Nullable
    public FileLock tryLockInfo(boolean shared) throws IOException {
        return this.lockInfoAccess.tryLock(this.lockFileAccess, shared);
    }

    @Nullable
    public FileLock tryLockState(boolean shared) throws IOException {
        return this.lockStateAccess.tryLock(this.lockFileAccess, shared);
    }

    public LockState readLockState() throws IOException {
        return this.lockStateAccess.readState(this.lockFileAccess);
    }
}

