/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourceVersionLister;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.ivypublish.IvyModuleArtifactPublishMetadata;
import org.gradle.internal.component.external.ivypublish.IvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentArtifactsResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceResolver<T extends ModuleComponentResolveMetadata>
implements ModuleVersionPublisher,
ConfiguredModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private static final StringInterner REPOSITORY_ID_INTERNER = new StringInterner();
    private final String name;
    private final List<ResourcePattern> ivyPatterns = new ArrayList<ResourcePattern>();
    private final List<ResourcePattern> artifactPatterns = new ArrayList<ResourcePattern>();
    private ComponentResolvers componentResolvers;
    private final ExternalResourceRepository repository;
    private final boolean local;
    private final CacheAwareExternalResourceAccessor cachingResourceAccessor;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final ImmutableMetadataSources metadataSources;
    private final MetadataArtifactProvider metadataArtifactProvider;
    private final InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory;
    private final InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister;
    private final Instantiator injector;
    private String id;
    private ExternalResourceArtifactResolver cachedArtifactResolver;

    protected ExternalResourceResolver(String name, boolean local, ExternalResourceRepository repository, CacheAwareExternalResourceAccessor cachingResourceAccessor, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, ImmutableMetadataSources metadataSources, MetadataArtifactProvider metadataArtifactProvider, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister, Instantiator injector) {
        this.name = name;
        this.local = local;
        this.cachingResourceAccessor = cachingResourceAccessor;
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.metadataSources = metadataSources;
        this.metadataArtifactProvider = metadataArtifactProvider;
        this.componentMetadataSupplierFactory = componentMetadataSupplierFactory;
        this.providedVersionLister = providedVersionLister;
        this.injector = injector;
    }

    @Override
    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = this.generateId(this);
        return this.id;
    }

    public ImmutableMetadataSources getMetadataSources() {
        return this.metadataSources;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract Class<T> getSupportedMetadataType();

    @Override
    public boolean isDynamicResolveMode() {
        return false;
    }

    public void setComponentResolvers(ComponentResolvers resolver) {
        this.componentResolvers = resolver;
    }

    protected ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    public Instantiator getComponentMetadataInstantiator() {
        return this.injector;
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.componentMetadataSupplierFactory;
    }

    @VisibleForTesting
    public InstantiatingAction<ComponentMetadataListerDetails> getProvidedVersionLister() {
        return this.providedVersionLister;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    private void doListModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
        ModuleIdentifier module = dependency.getSelector().getModuleIdentifier();
        this.tryListingViaRule(module, result);
        if (result.hasResult() && result.isAuthoritative()) {
            return;
        }
        ResourceVersionLister versionLister = new ResourceVersionLister(this.repository);
        List<ResourcePattern> completeIvyPatterns = this.filterComplete(this.ivyPatterns, module);
        List<ResourcePattern> completeArtifactPatterns = this.filterComplete(this.artifactPatterns, module);
        for (MetadataSource metadataSource : this.metadataSources.sources()) {
            metadataSource.listModuleVersions(dependency, module, completeIvyPatterns, completeArtifactPatterns, versionLister, result);
            if (!result.hasResult() || !result.isAuthoritative()) continue;
            return;
        }
        result.listed((Collection<String>)ImmutableSet.of());
    }

    private void tryListingViaRule(ModuleIdentifier module, BuildableModuleVersionListingResolveResult result) {
        if (this.providedVersionLister != null) {
            this.providedVersionLister.execute((Object)new DefaultComponentVersionsLister(module, result));
        }
    }

    private List<ResourcePattern> filterComplete(List<ResourcePattern> ivyPatterns, final ModuleIdentifier module) {
        return CollectionUtils.filter(ivyPatterns, (Spec)new Spec<ResourcePattern>(){

            public boolean isSatisfiedBy(ResourcePattern element) {
                return element.isComplete(module);
            }
        });
    }

    protected void doResolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult result) {
        this.resolveStaticDependency(moduleComponentIdentifier, prescribedMetaData, result, this.createArtifactResolver());
    }

    protected final void resolveStaticDependency(ModuleComponentIdentifier moduleVersionIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult result, ExternalResourceArtifactResolver artifactResolver) {
        for (MetadataSource source : this.metadataSources.sources()) {
            Object value = source.create(this.name, this.componentResolvers, moduleVersionIdentifier, prescribedMetaData, artifactResolver, result);
            if (value == null) continue;
            value.setSource(artifactResolver.getSource());
            result.resolved(value.asImmutable());
            return;
        }
        LOGGER.debug("No meta-data file or artifact found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
        result.missing();
    }

    protected abstract boolean isMetaDataArtifact(ArtifactType var1);

    protected Set<ModuleComponentArtifactMetadata> findOptionalArtifacts(ModuleComponentResolveMetadata module, String type, String classifier) {
        ModuleComponentArtifactMetadata artifact = module.artifact(type, "jar", classifier);
        if (this.createArtifactResolver(module.getSource()).artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return ImmutableSet.of((Object)artifact);
        }
        return Collections.emptySet();
    }

    private ModuleDescriptorArtifactMetadata getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.metadataArtifactProvider.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        return new DefaultModuleDescriptorArtifactMetadata(moduleComponentIdentifier, ivyArtifactName);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver() {
        ExternalResourceArtifactResolver artifactResolver;
        if (this.cachedArtifactResolver != null) {
            return this.cachedArtifactResolver;
        }
        this.cachedArtifactResolver = artifactResolver = this.createArtifactResolver(this.ivyPatterns, this.artifactPatterns);
        return artifactResolver;
    }

    private ExternalResourceArtifactResolver createArtifactResolver(List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns) {
        return new DefaultExternalResourceArtifactResolver(this.repository, this.locallyAvailableResourceFinder, ivyPatterns, artifactPatterns, this.artifactFileStore, this.cachingResourceAccessor);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSource moduleSource) {
        return this.createArtifactResolver();
    }

    @Override
    public void publish(IvyModulePublishMetadata moduleVersion) {
        for (IvyModuleArtifactPublishMetadata artifact : moduleVersion.getArtifacts()) {
            this.publish(new DefaultModuleComponentArtifactMetadata(artifact.getId()), artifact.getFile());
        }
    }

    private void publish(ModuleComponentArtifactMetadata artifact, File src) {
        ResourcePattern destinationPattern;
        if ("ivy".equals(artifact.getName().getType()) && !this.ivyPatterns.isEmpty()) {
            destinationPattern = this.ivyPatterns.get(0);
        } else if (!this.artifactPatterns.isEmpty()) {
            destinationPattern = this.artifactPatterns.get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ExternalResourceName destination = destinationPattern.getLocation(artifact);
        this.put(src, destination);
        LOGGER.info("Published {} to {}", (Object)artifact, (Object)destination);
    }

    private void put(File src, ExternalResourceName destination) {
        this.repository.withProgressLogging().resource(destination).put((ReadableContent)new FileReadableContent(src));
        this.putChecksum(src, destination);
    }

    private void putChecksum(File source, ExternalResourceName destination) {
        byte[] checksumFile = this.createChecksumFile(source, "SHA1", 40);
        ExternalResourceName checksumDestination = destination.append(".sha1");
        this.repository.resource(checksumDestination).put((ReadableContent)new ByteArrayReadableContent(checksumFile));
    }

    private byte[] createChecksumFile(File src, String algorithm, int checksumLength) {
        HashValue hash = HashUtil.createHash((File)src, (String)algorithm);
        String formattedHashString = hash.asZeroPaddedHexString(checksumLength);
        try {
            return formattedHashString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    protected void addIvyPattern(ResourcePattern pattern) {
        this.invalidateCaches();
        this.ivyPatterns.add(pattern);
    }

    private void invalidateCaches() {
        this.id = null;
        this.cachedArtifactResolver = null;
    }

    protected void addArtifactPattern(ResourcePattern pattern) {
        this.invalidateCaches();
        this.artifactPatterns.add(pattern);
    }

    public List<String> getIvyPatterns() {
        return CollectionUtils.collect(this.ivyPatterns, (Transformer)new Transformer<String, ResourcePattern>(){

            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    public List<String> getArtifactPatterns() {
        return CollectionUtils.collect(this.artifactPatterns, (Transformer)new Transformer<String, ResourcePattern>(){

            public String transform(ResourcePattern original) {
                return original.getPattern();
            }
        });
    }

    protected void setIvyPatterns(Iterable<? extends ResourcePattern> patterns) {
        this.invalidateCaches();
        this.ivyPatterns.clear();
        CollectionUtils.addAll(this.ivyPatterns, patterns);
    }

    protected void setArtifactPatterns(List<ResourcePattern> patterns) {
        this.invalidateCaches();
        this.artifactPatterns.clear();
        CollectionUtils.addAll(this.artifactPatterns, patterns);
    }

    private String generateId(ExternalResourceResolver resolver) {
        Hasher cacheHasher = Hashing.newHasher();
        cacheHasher.putString((CharSequence)this.getClass().getName());
        cacheHasher.putInt(resolver.ivyPatterns.size());
        for (ResourcePattern ivyPattern : this.ivyPatterns) {
            cacheHasher.putString((CharSequence)ivyPattern.getPattern());
        }
        cacheHasher.putInt(this.artifactPatterns.size());
        for (ResourcePattern artifactPattern : this.artifactPatterns) {
            cacheHasher.putString((CharSequence)artifactPattern.getPattern());
        }
        this.appendId(cacheHasher);
        return REPOSITORY_ID_INTERNER.intern(cacheHasher.hash().toString());
    }

    protected void appendId(Hasher hasher) {
        this.getMetadataSources().appendId(hasher);
    }

    private static class DefaultComponentVersionsLister
    implements ComponentMetadataListerDetails {
        private final ModuleIdentifier id;
        private final BuildableModuleVersionListingResolveResult result;

        private DefaultComponentVersionsLister(ModuleIdentifier id, BuildableModuleVersionListingResolveResult result) {
            this.id = id;
            this.result = result;
        }

        public ModuleIdentifier getModuleIdentifier() {
            return this.id;
        }

        public void listed(List<String> versions) {
            this.result.listed(versions);
        }
    }

    private static class NoOpResourceAwareResolveResult
    implements ResourceAwareResolveResult {
        private static final NoOpResourceAwareResolveResult INSTANCE = new NoOpResourceAwareResolveResult();

        private NoOpResourceAwareResolveResult() {
        }

        @Override
        public List<String> getAttempted() {
            return Collections.emptyList();
        }

        @Override
        public void attempted(String locationDescription) {
        }

        @Override
        public void attempted(ExternalResourceName location) {
        }

        @Override
        public void applyTo(ResourceAwareResolveResult target) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class RemoteRepositoryAccess
    extends AbstractRepositoryAccess {
        protected RemoteRepositoryAccess() {
        }

        public String toString() {
            return "remote > " + ExternalResourceResolver.this.toString();
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
            ExternalResourceResolver.this.doListModuleVersions(dependency, result);
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
            ExternalResourceResolver.this.doResolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result);
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            super.resolveArtifactsWithType(component, artifactType, result);
            this.checkArtifactsResolved(component, artifactType, result);
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            super.resolveArtifacts(component, result);
            this.checkArtifactsResolved(component, "artifacts", result);
        }

        private void checkArtifactsResolved(ComponentResolveMetadata component, Object context, BuildableTypedResolveResult<?, ? super ArtifactResolveException> result) {
            if (!result.hasResult()) {
                result.failed(new ArtifactResolveException(component.getId(), String.format("Cannot locate %s for '%s' in repository '%s'", context, component, ExternalResourceResolver.this.name)));
            }
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result) {
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
            try {
                ExternalResourceArtifactResolver resolver = ExternalResourceResolver.this.createArtifactResolver(moduleSource);
                ModuleComponentArtifactMetadata moduleArtifact = (ModuleComponentArtifactMetadata)artifact;
                LocallyAvailableExternalResource artifactResource = resolver.resolveArtifact(moduleArtifact, result);
                if (artifactResource == null) {
                    result.notFound(artifact.getId());
                } else {
                    result.resolved(artifactResource.getFile());
                }
            }
            catch (Exception e) {
                result.failed(new ArtifactResolveException(artifact.getId(), (Throwable)e));
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            if (ExternalResourceResolver.this.local) {
                ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(moduleComponentIdentifier);
                if (ExternalResourceResolver.this.createArtifactResolver().artifactExists(artifact, NoOpResourceAwareResolveResult.INSTANCE)) {
                    return MetadataFetchingCost.FAST;
                }
                return MetadataFetchingCost.CHEAP;
            }
            return MetadataFetchingCost.EXPENSIVE;
        }
    }

    protected abstract class LocalRepositoryAccess
    extends AbstractRepositoryAccess {
        protected LocalRepositoryAccess() {
        }

        public String toString() {
            return "local > " + ExternalResourceResolver.this.toString();
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result) {
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult result) {
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result) {
            ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(module.getId());
            result.resolved(Collections.singleton(artifact));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSource moduleSource, BuildableArtifactResolveResult result) {
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return MetadataFetchingCost.CHEAP;
        }
    }

    protected abstract class AbstractRepositoryAccess
    implements ModuleComponentRepositoryAccess {
        protected AbstractRepositoryAccess() {
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            ModuleComponentResolveMetadata moduleMetaData = (ModuleComponentResolveMetadata)ExternalResourceResolver.this.getSupportedMetadataType().cast(component);
            if (artifactType == ArtifactType.JAVADOC) {
                this.resolveJavadocArtifacts(moduleMetaData, result);
            } else if (artifactType == ArtifactType.SOURCES) {
                this.resolveSourceArtifacts(moduleMetaData, result);
            } else if (ExternalResourceResolver.this.isMetaDataArtifact(artifactType)) {
                this.resolveMetaDataArtifacts(moduleMetaData, result);
            }
        }

        @Override
        public void resolveArtifacts(ComponentResolveMetadata component, BuildableComponentArtifactsResolveResult result) {
            ModuleComponentResolveMetadata moduleMetaData = (ModuleComponentResolveMetadata)ExternalResourceResolver.this.getSupportedMetadataType().cast(component);
            this.resolveModuleArtifacts(moduleMetaData, result);
        }

        protected abstract void resolveModuleArtifacts(T var1, BuildableComponentArtifactsResolveResult var2);

        protected abstract void resolveMetaDataArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveJavadocArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveSourceArtifacts(T var1, BuildableArtifactSetResolveResult var2);
    }
}

