/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.resolver;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.resolver.GradleInstallation;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequest;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequestKt;
import org.gradle.kotlin.dsl.resolver.KotlinBuildScriptModelRequestKt$WhenMappings;
import org.gradle.kotlin.dsl.support.IOKt;
import org.gradle.kotlin.dsl.support.KotlinScriptType;
import org.gradle.kotlin.dsl.support.KotlinScriptTypeKt;
import org.gradle.kotlin.dsl.tooling.models.KotlinBuildScriptModel;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122#\b\u0002\u0010\u0015\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u0002`\u0019\u00a2\u0006\u0002\b\u001aH\u0007\u001a;\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0015\u001a\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u0002`\u0019\u00a2\u0006\u0002\b\u001aH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\b\u0010\u001e\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a$\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\fH\u0000\u001a8\u0010$\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010\u00140\u0014 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00170\u0017*\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000*:\b\u0000\u0010&\"\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u001a2\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0002\b\u001a\u00a8\u0006'"}, d2={"kotlinBuildScriptModelCorrelationId", "", "kotlinBuildScriptModelTarget", "kotlinBuildScriptModelTask", "modelSpecificJvmOptions", "", "applyGradleInstallationTo", "Lorg/gradle/tooling/GradleConnector;", "connector", "gradleInstallation", "Lorg/gradle/kotlin/dsl/resolver/GradleInstallation;", "buildSrcProjectDirOf", "Ljava/io/File;", "scriptFile", "importedProjectDir", "connectorFor", "projectDir", "request", "Lorg/gradle/kotlin/dsl/resolver/KotlinBuildScriptModelRequest;", "fetchKotlinBuildScriptModelFor", "Lorg/gradle/kotlin/dsl/tooling/models/KotlinBuildScriptModel;", "modelBuilderCustomization", "Lkotlin/Function1;", "Lorg/gradle/tooling/ModelBuilder;", "", "Lorg/gradle/kotlin/dsl/resolver/ModelBuilderCustomization;", "Lkotlin/ExtensionFunctionType;", "fetchKotlinBuildScriptModelFrom", "hasProjectDependentClassPath", "", "newCorrelationId", "projectConnectionFor", "Lorg/gradle/tooling/ProjectConnection;", "projectRootOf", "importedProjectRoot", "stopAt", "modelBuilderFor", "kotlin.jvm.PlatformType", "ModelBuilderCustomization", "gradle-kotlin-dsl"})
public final class KotlinBuildScriptModelRequestKt {
    private static final List<String> modelSpecificJvmOptions = CollectionsKt.listOf((Object)"-Dorg.gradle.kotlin.dsl.provider.mode=classpath");
    @NotNull
    public static final String kotlinBuildScriptModelTarget = "org.gradle.kotlin.dsl.provider.script";
    @NotNull
    public static final String kotlinBuildScriptModelCorrelationId = "org.gradle.kotlin.dsl.provider.cid";
    @NotNull
    public static final String kotlinBuildScriptModelTask = "prepareKotlinBuildScriptModel";

    @NotNull
    public static final String newCorrelationId() {
        return String.valueOf(System.nanoTime());
    }

    @VisibleForTesting
    @NotNull
    public static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFor(@NotNull KotlinBuildScriptModelRequest request, @NotNull Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit> modelBuilderCustomization) {
        File externalProjectRoot;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(modelBuilderCustomization, (String)"modelBuilderCustomization");
        File importedProjectDir = request.getProjectDir();
        File file = request.getScriptFile();
        if (file == null) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(importedProjectDir, request, modelBuilderCustomization);
        }
        File scriptFile = file;
        File file2 = KotlinBuildScriptModelRequestKt.buildSrcProjectDirOf(scriptFile, importedProjectDir);
        if (file2 == null) {
            file2 = importedProjectDir;
        }
        File effectiveProjectDir = file2;
        KotlinBuildScriptModel scriptModel = KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(effectiveProjectDir, request, modelBuilderCustomization);
        if (scriptModel.getEnclosingScriptProjectDir() == null && KotlinBuildScriptModelRequestKt.hasProjectDependentClassPath(scriptFile) && Intrinsics.areEqual((Object)(externalProjectRoot = KotlinBuildScriptModelRequestKt.projectRootOf$default(scriptFile, importedProjectDir, null, 4, null)), (Object)importedProjectDir) ^ true) {
            return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFrom(externalProjectRoot, request, modelBuilderCustomization);
        }
        return scriptModel;
    }

    @VisibleForTesting
    @NotNull
    public static /* synthetic */ KotlinBuildScriptModel fetchKotlinBuildScriptModelFor$default(KotlinBuildScriptModelRequest kotlinBuildScriptModelRequest, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = fetchKotlinBuildScriptModelFor.1.INSTANCE;
        }
        return KotlinBuildScriptModelRequestKt.fetchKotlinBuildScriptModelFor(kotlinBuildScriptModelRequest, (Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit>)function1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasProjectDependentClassPath(File scriptFile) {
        KotlinScriptType kotlinScriptType = KotlinScriptTypeKt.kotlinScriptTypeFor(scriptFile);
        if (kotlinScriptType == null) return true;
        switch (KotlinBuildScriptModelRequestKt$WhenMappings.$EnumSwitchMapping$0[kotlinScriptType.ordinal()]) {
            case 1: {
                return false;
            }
            default: {
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KotlinBuildScriptModel fetchKotlinBuildScriptModelFrom(File projectDir, KotlinBuildScriptModelRequest request, Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit> modelBuilderCustomization) {
        KotlinBuildScriptModel kotlinBuildScriptModel;
        ProjectConnection projectConnection;
        ProjectConnection connection = projectConnection = KotlinBuildScriptModelRequestKt.projectConnectionFor(request, projectDir);
        boolean bl = false;
        try {
            kotlinBuildScriptModel = KotlinBuildScriptModelRequestKt.modelBuilderFor(connection, request);
            Function1<? super ModelBuilder<KotlinBuildScriptModel>, Unit> function1 = modelBuilderCustomization;
            function1.invoke(kotlinBuildScriptModel);
            Object object = kotlinBuildScriptModel.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"connection.modelBuilderF\u2026ilderCustomization).get()");
            kotlinBuildScriptModel = (KotlinBuildScriptModel)object;
        }
        finally {
            connection.close();
        }
        KotlinBuildScriptModel kotlinBuildScriptModel2 = kotlinBuildScriptModel;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinBuildScriptModel2, (String)"projectConnectionFor(req\u2026n.close()\n        }\n    }");
        return kotlinBuildScriptModel2;
    }

    private static final ProjectConnection projectConnectionFor(KotlinBuildScriptModelRequest request, File projectDir) {
        ProjectConnection projectConnection = KotlinBuildScriptModelRequestKt.connectorFor(request, projectDir).connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectConnection, (String)"connectorFor(request, projectDir).connect()");
        return projectConnection;
    }

    private static final ModelBuilder<KotlinBuildScriptModel> modelBuilderFor(@NotNull ProjectConnection $receiver, KotlinBuildScriptModelRequest request) {
        ModelBuilder modelBuilder;
        ModelBuilder $receiver2 = modelBuilder = $receiver.model(KotlinBuildScriptModel.class);
        boolean bl = false;
        $receiver2.setJavaHome(request.getJavaHome());
        $receiver2.setJvmArguments((Iterable)CollectionsKt.plus((Collection)request.getJvmOptions(), (Iterable)modelSpecificJvmOptions));
        $receiver2.forTasks(new String[]{kotlinBuildScriptModelTask});
        List arguments = CollectionsKt.toMutableList((Collection)request.getOptions());
        Object object = arguments;
        String string2 = "-Porg.gradle.kotlin.dsl.provider.cid=" + request.getCorrelationId();
        object.add(string2);
        File file = request.getScriptFile();
        if (file != null) {
            Object it = object = file;
            boolean bl2 = false;
            Collection collection = arguments;
            String string3 = "-Porg.gradle.kotlin.dsl.provider.script=" + ((File)it).getCanonicalPath();
            collection.add(string3);
        }
        $receiver2.withArguments((Iterable)arguments);
        return modelBuilder;
    }

    private static final GradleConnector connectorFor(KotlinBuildScriptModelRequest request, File projectDir) {
        GradleConnector gradleConnector = KotlinBuildScriptModelRequestKt.connectorFor(projectDir, request.getGradleInstallation()).useGradleUserHomeDir(request.getGradleUserHome());
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector, (String)"connectorFor(projectDir,\u2026r(request.gradleUserHome)");
        return gradleConnector;
    }

    private static final File buildSrcProjectDirOf(File scriptFile, File importedProjectDir) {
        File file;
        File buildSrc = file = FilesKt.resolve((File)importedProjectDir, (String)"buildSrc");
        boolean bl = false;
        return buildSrc.isDirectory() && IOKt.isParentOf(buildSrc, scriptFile) ? file : null;
    }

    @NotNull
    public static final File projectRootOf(@NotNull File scriptFile, @NotNull File importedProjectRoot, @Nullable File stopAt) {
        Intrinsics.checkParameterIsNotNull((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkParameterIsNotNull((Object)importedProjectRoot, (String)"importedProjectRoot");
        projectRootOf.1 isProjectRoot$ = projectRootOf.1.INSTANCE;
        Function1<File, File> test$ = new Function1<File, File>(importedProjectRoot, stopAt, scriptFile){
            final /* synthetic */ File $importedProjectRoot;
            final /* synthetic */ File $stopAt;
            final /* synthetic */ File $scriptFile;

            @NotNull
            public final File invoke(@NotNull File dir) {
                File file;
                block3: {
                    while (true) {
                        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                        if (Intrinsics.areEqual((Object)dir, (Object)this.$importedProjectRoot)) {
                            file = this.$importedProjectRoot;
                            break block3;
                        }
                        if (projectRootOf.1.INSTANCE.invoke(dir)) {
                            file = dir;
                            break block3;
                        }
                        File parentDir = dir.getParentFile();
                        File file2 = parentDir;
                        if (file2 == null || Intrinsics.areEqual((Object)file2, (Object)dir) || Intrinsics.areEqual((Object)file2, (Object)this.$stopAt)) break;
                        dir = parentDir;
                    }
                    File file3 = this.$scriptFile.getParentFile();
                    file = file3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"when (parentDir) {\n     \u2026entDir)\n                }");
                }
                return file;
            }
            {
                this.$importedProjectRoot = file;
                this.$stopAt = file2;
                this.$scriptFile = file3;
                super(1);
            }
        };
        File file = scriptFile.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"scriptFile.parentFile");
        return test$.invoke(file);
    }

    @NotNull
    public static /* synthetic */ File projectRootOf$default(File file, File file2, File file3, int n, Object object) {
        if ((n & 4) != 0) {
            file3 = null;
        }
        return KotlinBuildScriptModelRequestKt.projectRootOf(file, file2, file3);
    }

    private static final GradleConnector connectorFor(File projectDir, GradleInstallation gradleInstallation) {
        GradleConnector gradleConnector;
        GradleConnector connector = gradleConnector = GradleConnector.newConnector().forProjectDirectory(projectDir);
        boolean bl = false;
        GradleConnector gradleConnector2 = connector;
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector2, (String)"connector");
        return KotlinBuildScriptModelRequestKt.applyGradleInstallationTo(gradleConnector2, gradleInstallation);
    }

    private static final GradleConnector applyGradleInstallationTo(GradleConnector connector, GradleInstallation gradleInstallation) {
        GradleConnector gradleConnector;
        GradleInstallation gradleInstallation2;
        GradleInstallation $receiver = gradleInstallation2 = gradleInstallation;
        boolean bl = false;
        GradleInstallation gradleInstallation3 = $receiver;
        if (gradleInstallation3 instanceof GradleInstallation.Local) {
            GradleConnector gradleConnector2 = connector.useInstallation(((GradleInstallation.Local)$receiver).getDir());
            gradleConnector = gradleConnector2;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector2, (String)"connector.useInstallation(dir)");
        } else if (gradleInstallation3 instanceof GradleInstallation.Remote) {
            GradleConnector gradleConnector3 = connector.useDistribution(((GradleInstallation.Remote)$receiver).getUri());
            gradleConnector = gradleConnector3;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector3, (String)"connector.useDistribution(uri)");
        } else if (gradleInstallation3 instanceof GradleInstallation.Version) {
            GradleConnector gradleConnector4 = connector.useGradleVersion(((GradleInstallation.Version)$receiver).getNumber());
            gradleConnector = gradleConnector4;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector4, (String)"connector.useGradleVersion(number)");
        } else if (Intrinsics.areEqual((Object)gradleInstallation3, (Object)GradleInstallation.Wrapper.INSTANCE)) {
            GradleConnector gradleConnector5 = connector.useBuildDistribution();
            gradleConnector = gradleConnector5;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleConnector5, (String)"connector.useBuildDistribution()");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gradleConnector;
    }
}

