/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import java.util.ArrayList;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.ApiRequirementNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.CachingLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.ChainedLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.InputHandlingNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.LibraryNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.ProjectLibraryBinaryLocator;
import org.gradle.nativeplatform.internal.resolve.RequirementParsingNativeDependencyResolver;
import org.gradle.nativeplatform.internal.resolve.SourceSetNativeDependencyResolver;

public class NativeDependencyResolverServices {
    public LibraryBinaryLocator createLibraryBinaryLocator(ProjectModelResolver projectModelResolver, CollectionCallbackActionDecorator callbackActionDecorator) {
        ArrayList<LibraryBinaryLocator> locators = new ArrayList<LibraryBinaryLocator>();
        locators.add(new ProjectLibraryBinaryLocator(projectModelResolver, callbackActionDecorator));
        locators.add(new PrebuiltLibraryBinaryLocator(projectModelResolver));
        return new CachingLibraryBinaryLocator(new ChainedLibraryBinaryLocator(locators));
    }

    public NativeDependencyResolver createResolver(LibraryBinaryLocator locator, FileCollectionFactory fileCollectionFactory) {
        NativeDependencyResolver resolver = new LibraryNativeDependencyResolver(locator);
        resolver = new ApiRequirementNativeDependencyResolver(resolver, fileCollectionFactory);
        resolver = new RequirementParsingNativeDependencyResolver(resolver);
        resolver = new SourceSetNativeDependencyResolver(resolver, fileCollectionFactory);
        return new InputHandlingNativeDependencyResolver(resolver);
    }
}

