/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.id.UniqueId;

public class ExecuteTaskBuildOperationResult
implements ExecuteTaskBuildOperationType.Result {
    private final TaskStateInternal taskState;
    private final TaskExecutionContext ctx;
    private final OriginMetadata originMetadata;

    public ExecuteTaskBuildOperationResult(TaskStateInternal taskState, TaskExecutionContext ctx, @Nullable OriginMetadata originMetadata) {
        this.taskState = taskState;
        this.ctx = ctx;
        this.originMetadata = originMetadata;
    }

    @Override
    @Nullable
    public String getSkipMessage() {
        return this.taskState.getSkipMessage();
    }

    @Override
    public boolean isActionable() {
        return this.taskState.isActionable();
    }

    @Override
    @Nullable
    public String getOriginBuildInvocationId() {
        UniqueId originBuildInvocationId = this.originMetadata == null ? null : this.originMetadata.getBuildInvocationId();
        return originBuildInvocationId == null ? null : originBuildInvocationId.asString();
    }

    @Override
    @Nullable
    public Long getOriginExecutionTime() {
        return this.originMetadata == null ? null : Long.valueOf(this.originMetadata.getExecutionTime());
    }

    @Override
    @Nullable
    public String getCachingDisabledReasonMessage() {
        TaskOutputCachingState taskOutputCaching = this.taskState.getTaskOutputCaching();
        return taskOutputCaching.getDisabledReason();
    }

    @Override
    @Nullable
    public String getCachingDisabledReasonCategory() {
        TaskOutputCachingState taskOutputCaching = this.taskState.getTaskOutputCaching();
        TaskOutputCachingDisabledReasonCategory disabledReasonCategory = taskOutputCaching.getDisabledReasonCategory();
        return disabledReasonCategory == null ? null : disabledReasonCategory.name();
    }

    @Override
    @Nullable
    public List<String> getUpToDateMessages() {
        return this.ctx.getUpToDateMessages();
    }

    @Override
    public boolean isIncremental() {
        return this.ctx.isTaskExecutedIncrementally();
    }
}

