/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Namer;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resource.local.FileAccessTimeJournal;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreSearcher;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.resource.local.SingleDepthFileAccessTracker;
import org.gradle.internal.resource.local.UniquePathKeyFileStore;

public class GroupedAndNamedUniqueFileStore<K>
implements FileStore<K>,
FileStoreSearcher<K> {
    protected static final int NUMBER_OF_CHECKSUM_DIRS = 1;
    private final PathKeyFileStore delegate;
    private final TemporaryFileProvider temporaryFileProvider;
    private final Grouper<K> grouper;
    private final Namer<K> namer;
    private final FileAccessTracker checksumDirAccessTracker;

    public GroupedAndNamedUniqueFileStore(File baseDir, TemporaryFileProvider temporaryFileProvider, FileAccessTimeJournal fileAccessTimeJournal, Grouper<K> grouper, Namer<K> namer) {
        this.delegate = new UniquePathKeyFileStore(baseDir);
        this.temporaryFileProvider = temporaryFileProvider;
        this.grouper = grouper;
        this.namer = namer;
        this.checksumDirAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, baseDir, grouper.getNumberOfGroupingDirs() + 1);
    }

    public LocallyAvailableResource move(K key, File source) {
        return this.markAccessed(this.delegate.move((Object)this.toPath(key, this.getChecksum(source)), source));
    }

    public Set<? extends LocallyAvailableResource> search(K key) {
        return this.delegate.search((Object)this.toPath(key, "*"));
    }

    public FileAccessTracker getFileAccessTracker() {
        return this.checksumDirAccessTracker;
    }

    private String toPath(K key, String checksumPart) {
        String group = this.grouper.determineGroup(key);
        String name = this.namer.determineName(key);
        return group + "/" + checksumPart + "/" + name;
    }

    private String getChecksum(File contentFile) {
        return HashUtil.createHash((File)contentFile, (String)"SHA1").asHexString();
    }

    private File getTempFile() {
        return this.temporaryFileProvider.createTemporaryFile("filestore", "bin", new String[0]);
    }

    public LocallyAvailableResource add(K key, Action<File> addAction) {
        File tempFile = this.getTempFile();
        addAction.execute((Object)tempFile);
        String groupedAndNamedKey = this.toPath(key, this.getChecksum(tempFile));
        return this.markAccessed(this.delegate.move((Object)groupedAndNamedKey, tempFile));
    }

    private LocallyAvailableResource markAccessed(LocallyAvailableResource resource) {
        this.checksumDirAccessTracker.markAccessed(resource.getFile());
        return resource;
    }

    public static interface Grouper<K> {
        public String determineGroup(K var1);

        public int getNumberOfGroupingDirs();
    }
}

