/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JavaProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class JavaLibraryProjectInitDescriptor
extends JavaProjectInitDescriptor {
    private static final JavaProjectInitDescriptor.Description DESCRIPTION = new JavaProjectInitDescriptor.Description("Java Library", "Java Libraries", "java_library_plugin", "java-library");

    public JavaLibraryProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider, documentationRegistry);
    }

    @Override
    public String getId() {
        return "java-library";
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings) {
        return this.fromClazzTemplate("javalibrary/Library.java.template", settings, "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return this.fromClazzTemplate("groovylibrary/LibraryTest.groovy.template", settings, "test", "groovy");
            }
            case TESTNG: {
                return this.fromClazzTemplate("javalibrary/testng/LibraryTest.java.template", settings, "test");
            }
            case JUNIT: {
                return this.fromClazzTemplate("javalibrary/LibraryTest.java.template", settings, "test");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected JavaProjectInitDescriptor.Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getImplementationConfigurationName() {
        return "implementation";
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", "org.apache.commons:commons-math3:" + this.libraryVersionProvider.getVersion("commons-math"));
        buildScriptBuilder.dependency(this.getImplementationConfigurationName(), "This dependency is used internally, and not exposed to consumers on their own compile classpath.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }
}

