/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.TypeIntersector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"intersectTypes", "Lorg/jetbrains/kotlin/types/SimpleType;", "types", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "intersectWrappedTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
public final class IntersectionTypeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnwrappedType intersectWrappedTypes(@NotNull Collection<? extends KotlinType> types) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Iterable iterable = $receiver$iv = (Iterable)types;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            UnwrappedType unwrappedType = it.unwrap();
            collection.add(unwrappedType);
        }
        return IntersectionTypeKt.intersectTypes((List)var3_3);
    }

    @NotNull
    public static final SimpleType intersectTypes(@NotNull List<? extends SimpleType> types) {
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        UnwrappedType unwrappedType = IntersectionTypeKt.intersectTypes(types);
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return (SimpleType)unwrappedType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnwrappedType intersectTypes(@NotNull List<? extends UnwrappedType> types) {
        void $receiver$iv$iv;
        SimpleType simpleType2;
        UnwrappedType unwrappedType;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        switch (types.size()) {
            case 0: {
                String string = "Expected some types";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                return (UnwrappedType)CollectionsKt.single(types);
            }
        }
        boolean hasFlexibleTypes = false;
        boolean hasErrorType = false;
        Iterable iterable = $receiver$iv = (Iterable)types;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            SimpleType simpleType3;
            void it;
            UnwrappedType unwrappedType2 = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv;
            hasErrorType = hasErrorType || KotlinTypeKt.isError((KotlinType)it);
            unwrappedType = it;
            if (unwrappedType instanceof SimpleType) {
                simpleType3 = (SimpleType)it;
            } else if (unwrappedType instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic((KotlinType)it)) {
                    return it;
                }
                hasFlexibleTypes = true;
                simpleType3 = ((FlexibleType)it).getLowerBound();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            simpleType2 = simpleType3;
            collection.add(simpleType2);
        }
        List lowerBounds = (List)destination$iv$iv;
        if (hasErrorType) {
            SimpleType simpleType4 = ErrorUtils.createErrorType("Intersection of error types: " + types);
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"ErrorUtils.createErrorTy\u2026 of error types: $types\")");
            return simpleType4;
        }
        if (!hasFlexibleTypes) {
            return TypeIntersector.INSTANCE.intersectTypes$descriptors(lowerBounds);
        }
        Iterable $receiver$iv2 = types;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            unwrappedType = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv2;
            simpleType2 = FlexibleTypesKt.upperIfFlexible((KotlinType)it);
            collection.add(simpleType2);
        }
        List upperBounds = (List)destination$iv$iv2;
        return KotlinTypeFactory.flexibleType(TypeIntersector.INSTANCE.intersectTypes$descriptors(lowerBounds), TypeIntersector.INSTANCE.intersectTypes$descriptors(upperBounds));
    }
}

