/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.CachingTransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvoker;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.IncrementalContext;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.impl.DefaultBeforeExecutionState;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.OutputNormalizer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.work.InputChanges;

public class DefaultTransformerInvoker
implements TransformerInvoker {
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final WorkExecutor<IncrementalContext, CachingResult> workExecutor;
    private final ArtifactTransformListener artifactTransformListener;
    private final CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final ProjectFinder projectFinder;

    public DefaultTransformerInvoker(WorkExecutor<IncrementalContext, CachingResult> workExecutor, FileSystemSnapshotter fileSystemSnapshotter, ArtifactTransformListener artifactTransformListener, CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, ProjectFinder projectFinder) {
        this.workExecutor = workExecutor;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableTransformationWorkspaceProvider = immutableTransformationWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.projectFinder = projectFinder;
    }

    @Override
    public Try<ImmutableList<File>> invoke(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        FileCollectionFingerprinter dependencyFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactDependenciesNormalizer());
        CurrentFileCollectionFingerprint dependenciesFingerprint = dependencies.fingerprint(dependencyFingerprinter);
        ProjectInternal producerProject = this.determineProducerProject(subject);
        CachingTransformationWorkspaceProvider workspaceProvider = this.determineWorkspaceProvider(producerProject);
        FileSystemLocationSnapshot inputArtifactSnapshot = this.fileSystemSnapshotter.snapshot(inputArtifact);
        FileCollectionFingerprinter inputArtifactFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactNormalizer());
        String normalizedInputPath = inputArtifactFingerprinter.normalizePath(inputArtifactSnapshot);
        TransformationWorkspaceIdentity identity = this.getTransformationIdentity(producerProject, inputArtifactSnapshot, normalizedInputPath, transformer, dependenciesFingerprint);
        return workspaceProvider.withWorkspace(identity, (identityString, workspace) -> this.fireTransformListeners(transformer, subject, () -> {
            String transformIdentity = "transform/" + identityString;
            ExecutionHistoryStore executionHistoryStore = workspaceProvider.getExecutionHistoryStore();
            FileCollectionFingerprinter outputFingerprinter = fingerprinterRegistry.getFingerprinter(OutputNormalizer.class);
            final Optional afterPreviousExecutionState = executionHistoryStore.load(transformIdentity);
            ImplementationSnapshot implementationSnapshot = ImplementationSnapshot.of(transformer.getImplementationClass(), (ClassLoaderHierarchyHasher)this.classLoaderHierarchyHasher);
            CurrentFileCollectionFingerprint inputArtifactFingerprint = inputArtifactFingerprinter.fingerprint((Iterable)ImmutableList.of((Object)inputArtifactSnapshot));
            ImmutableSortedMap<String, ValueSnapshot> inputFingerprints = DefaultTransformerInvoker.snapshotInputs(transformer);
            ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputsBeforeExecution = DefaultTransformerInvoker.snapshotOutputs(outputFingerprinter, this.fileCollectionFactory, workspace);
            ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileFingerprints = DefaultTransformerInvoker.createInputFileFingerprints(inputArtifactFingerprint, dependenciesFingerprint);
            DefaultBeforeExecutionState beforeExecutionState = new DefaultBeforeExecutionState(implementationSnapshot, ImmutableList.of(), inputFingerprints, inputFileFingerprints, outputsBeforeExecution);
            final TransformerExecution execution = new TransformerExecution(transformer, workspace, transformIdentity, executionHistoryStore, this.fileCollectionFactory, inputArtifact, dependencies, outputFingerprinter);
            CachingResult outcome = (CachingResult)this.workExecutor.execute((Context)new IncrementalContext((BeforeExecutionState)beforeExecutionState){
                final /* synthetic */ BeforeExecutionState val$beforeExecutionState;
                {
                    this.val$beforeExecutionState = beforeExecutionState;
                }

                public UnitOfWork getWork() {
                    return execution;
                }

                public Optional<String> getRebuildReason() {
                    return Optional.empty();
                }

                public Optional<AfterPreviousExecutionState> getAfterPreviousExecutionState() {
                    return afterPreviousExecutionState;
                }

                public Optional<BeforeExecutionState> getBeforeExecutionState() {
                    return Optional.of(this.val$beforeExecutionState);
                }
            });
            return outcome.getOutcome().map(outcome1 -> execution.loadResultsFile()).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure));
        }));
    }

    private TransformationWorkspaceIdentity getTransformationIdentity(@Nullable ProjectInternal project, FileSystemLocationSnapshot inputArtifactSnapshot, String inputArtifactPath, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return project == null ? this.getImmutableTransformationIdentity(inputArtifactPath, inputArtifactSnapshot, transformer, dependenciesFingerprint) : this.getMutableTransformationIdentity(inputArtifactSnapshot, transformer, dependenciesFingerprint);
    }

    private TransformationWorkspaceIdentity getImmutableTransformationIdentity(String inputArtifactPath, FileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new ImmutableTransformationWorkspaceIdentity(inputArtifactPath, inputArtifactSnapshot.getHash(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private TransformationWorkspaceIdentity getMutableTransformationIdentity(FileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new MutableTransformationWorkspaceIdentity(inputArtifactSnapshot.getAbsolutePath(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private CachingTransformationWorkspaceProvider determineWorkspaceProvider(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableTransformationWorkspaceProvider;
        }
        return (CachingTransformationWorkspaceProvider)producerProject.getServices().get(CachingTransformationWorkspaceProvider.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        if (!subject.getProducer().isPresent()) {
            return null;
        }
        ProjectComponentIdentifier projectComponentIdentifier = subject.getProducer().get();
        return this.projectFinder.findProject(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Try<ImmutableList<File>> fireTransformListeners(Transformer transformer, TransformationSubject subject, Supplier<Try<ImmutableList<File>>> execution) {
        this.artifactTransformListener.beforeTransformerInvocation((Describable)transformer, (Describable)subject);
        try {
            Try<ImmutableList<File>> try_ = execution.get();
            return try_;
        }
        finally {
            this.artifactTransformListener.afterTransformerInvocation((Describable)transformer, (Describable)subject);
        }
    }

    private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> createInputFileFingerprints(CurrentFileCollectionFingerprint inputArtifactFingerprint, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        builder.put((Object)INPUT_ARTIFACT_PROPERTY_NAME, (Object)inputArtifactFingerprint);
        builder.put((Object)DEPENDENCIES_PROPERTY_NAME, (Object)dependenciesFingerprint);
        return builder.build();
    }

    private static ImmutableSortedMap<String, ValueSnapshot> snapshotInputs(Transformer transformer) {
        return ImmutableSortedMap.of((Comparable)((Object)SECONDARY_INPUTS_HASH_PROPERTY_NAME), (Object)ImplementationSnapshot.of((String)"secondary inputs", (HashCode)transformer.getSecondaryInputHash()));
    }

    private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotOutputs(FileCollectionFingerprinter outputFingerprinter, FileCollectionFactory fileCollectionFactory, TransformationWorkspaceProvider.TransformationWorkspace workspace) {
        CurrentFileCollectionFingerprint outputFingerprint = outputFingerprinter.fingerprint((FileCollection)fileCollectionFactory.fixed(new File[]{workspace.getOutputDirectory()}));
        CurrentFileCollectionFingerprint resultsFileFingerprint = outputFingerprinter.fingerprint((FileCollection)fileCollectionFactory.fixed(new File[]{workspace.getResultsFile()}));
        return ImmutableSortedMap.of((Comparable)((Object)OUTPUT_DIRECTORY_PROPERTY_NAME), (Object)outputFingerprint, (Comparable)((Object)RESULTS_FILE_PROPERTY_NAME), (Object)resultsFileFingerprint);
    }

    public static class MutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactAbsolutePath;
        private final HashCode secondaryInputsHash;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String inputArtifactAbsolutePath, HashCode secondaryInputsHash, HashCode dependenciesHash) {
            this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
            this.secondaryInputsHash = secondaryInputsHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactAbsolutePath);
            hasher.putHash(this.secondaryInputsHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsHash.equals((Object)that.secondaryInputsHash)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
        }

        public int hashCode() {
            int result = this.inputArtifactAbsolutePath.hashCode();
            result = 31 * result + this.secondaryInputsHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class ImmutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactPath;
        private final HashCode inputArtifactHash;
        private final HashCode secondaryInputHash;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(String inputArtifactPath, HashCode inputArtifactHash, HashCode secondaryInputHash, HashCode dependenciesHash) {
            this.inputArtifactPath = inputArtifactPath;
            this.inputArtifactHash = inputArtifactHash;
            this.secondaryInputHash = secondaryInputHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactPath);
            hasher.putHash(this.inputArtifactHash);
            hasher.putHash(this.secondaryInputHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.inputArtifactHash.equals((Object)that.inputArtifactHash)) {
                return false;
            }
            if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
                return false;
            }
            if (!this.secondaryInputHash.equals((Object)that.secondaryInputHash)) {
                return false;
            }
            return this.dependenciesHash.equals((Object)that.dependenciesHash);
        }

        public int hashCode() {
            int result = this.inputArtifactHash.hashCode();
            result = 31 * result + this.secondaryInputHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class TransformerExecution
    implements UnitOfWork {
        private final Transformer transformer;
        private final TransformationWorkspaceProvider.TransformationWorkspace workspace;
        private final File inputArtifact;
        private final String identityString;
        private final ExecutionHistoryStore executionHistoryStore;
        private final FileCollectionFactory fileCollectionFactory;
        private final ArtifactTransformDependencies dependencies;
        private final FileCollectionFingerprinter outputFingerprinter;
        private final Timer executionTimer;
        private final Provider<FileSystemLocation> inputArtifactProvider;

        public TransformerExecution(Transformer transformer, TransformationWorkspaceProvider.TransformationWorkspace workspace, String identityString, ExecutionHistoryStore executionHistoryStore, FileCollectionFactory fileCollectionFactory, final File inputArtifact, ArtifactTransformDependencies dependencies, FileCollectionFingerprinter outputFingerprinter) {
            this.fileCollectionFactory = fileCollectionFactory;
            this.inputArtifact = inputArtifact;
            this.transformer = transformer;
            this.workspace = workspace;
            this.identityString = identityString;
            this.executionHistoryStore = executionHistoryStore;
            this.dependencies = dependencies;
            this.outputFingerprinter = outputFingerprinter;
            this.executionTimer = Time.startTimer();
            this.inputArtifactProvider = Providers.of((Object)new FileSystemLocation(){

                public File getAsFile() {
                    return inputArtifact;
                }

                public String toString() {
                    return inputArtifact.toString();
                }
            });
        }

        public UnitOfWork.WorkResult execute(@Nullable InputChangesInternal inputChanges) {
            File outputDir = this.workspace.getOutputDirectory();
            File resultsFile = this.workspace.getResultsFile();
            ImmutableList<File> result = this.transformer.transform(this.inputArtifactProvider, outputDir, this.dependencies, (InputChanges)inputChanges);
            this.writeResultsFile(outputDir, resultsFile, result);
            return UnitOfWork.WorkResult.DID_WORK;
        }

        private void writeResultsFile(File outputDir, File resultsFile, ImmutableList<File> result) {
            String outputDirPrefix = outputDir.getPath() + File.separator;
            String inputFilePrefix = this.inputArtifact.getPath() + File.separator;
            Stream<String> relativePaths = result.stream().map(file -> {
                if (file.equals(outputDir)) {
                    return DefaultTransformerInvoker.OUTPUT_FILE_PATH_PREFIX;
                }
                if (file.equals(this.inputArtifact)) {
                    return DefaultTransformerInvoker.INPUT_FILE_PATH_PREFIX;
                }
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    return DefaultTransformerInvoker.OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(outputDirPrefix.length())).getPathString();
                }
                if (absolutePath.startsWith(inputFilePrefix)) {
                    return DefaultTransformerInvoker.INPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(inputFilePrefix.length())).getPathString();
                }
                throw new IllegalStateException("Invalid result path: " + absolutePath);
            });
            UncheckedException.callUnchecked(() -> Files.write(resultsFile.toPath(), relativePaths::iterator, new OpenOption[0]));
        }

        private ImmutableList<File> loadResultsFile() {
            Path transformerResultsPath = this.workspace.getResultsFile().toPath();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
                for (String path : paths) {
                    if (path.startsWith(DefaultTransformerInvoker.OUTPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.workspace.getOutputDirectory(), path.substring(2)));
                        continue;
                    }
                    if (path.startsWith(DefaultTransformerInvoker.INPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.inputArtifact, path.substring(2)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot parse result path string: " + path);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public ExecutionHistoryStore getExecutionHistoryStore() {
            return this.executionHistoryStore;
        }

        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            return this.transformer.requiresInputChanges() ? UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS : UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        public void visitInputFileProperties(UnitOfWork.InputFilePropertyVisitor visitor) {
            visitor.visitInputFileProperty(DefaultTransformerInvoker.INPUT_ARTIFACT_PROPERTY_NAME, this.inputArtifactProvider, true);
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            visitor.visitOutputProperty(DefaultTransformerInvoker.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, (FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getOutputDirectory()}));
            visitor.visitOutputProperty(DefaultTransformerInvoker.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, (FileCollection)this.fileCollectionFactory.fixed(new File[]{this.workspace.getResultsFile()}));
        }

        public boolean isAllowOverlappingOutputs() {
            return false;
        }

        public boolean hasOverlappingOutputs() {
            return false;
        }

        public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
            return true;
        }

        public long markExecutionTime() {
            return this.executionTimer.getElapsedMillis();
        }

        public void visitLocalState(UnitOfWork.LocalStateVisitor visitor) {
        }

        public Optional<CachingDisabledReason> shouldDisableCaching() {
            return this.transformer.isCacheable() ? Optional.empty() : Optional.of(NOT_CACHEABLE);
        }

        public boolean isAllowedToLoadFromCache() {
            return true;
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.of(ImmutableList.of((Object)this.workspace.getOutputDirectory().getAbsolutePath(), (Object)this.workspace.getResultsFile().getAbsolutePath()));
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated() {
            return DefaultTransformerInvoker.snapshotOutputs(this.outputFingerprinter, this.fileCollectionFactory, this.workspace);
        }

        public String getIdentity() {
            return this.identityString;
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            visitor.visitOutputTree(DefaultTransformerInvoker.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, this.workspace.getOutputDirectory());
            visitor.visitOutputTree(DefaultTransformerInvoker.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, this.workspace.getResultsFile());
        }

        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.inputArtifact;
        }
    }
}

