/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.StartParameter;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;

public class DefaultSettingsLoader
implements SettingsLoader {
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;
    private BuildSourceBuilder buildSourceBuilder;

    public DefaultSettingsLoader(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings;
        StartParameter startParameter = gradle.getStartParameter();
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter, settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter));
        if (this.useEmptySettings(spec, settings, startParameter)) {
            settings = this.createEmptySettings(gradle, startParameter);
        }
        this.setDefaultProject(spec, settings);
        return settings;
    }

    private boolean useEmptySettings(ProjectSpec spec, SettingsInternal loadedSettings, StartParameter startParameter) {
        if (startParameter.getSettingsFile() != null) {
            return false;
        }
        if (spec.containsProject(loadedSettings.getProjectRegistry())) {
            return false;
        }
        return startParameter.getProjectDir() != null && loadedSettings.getSettingsDir().equals(startParameter.getProjectDir());
    }

    private SettingsInternal createEmptySettings(GradleInternal gradle, StartParameter startParameter) {
        StartParameter noSearchParameter = startParameter.newInstance();
        noSearchParameter.useEmptySettings();
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter);
        if (noSearchParameter.getBuildFile() != null) {
            ProjectDescriptor rootProject = settings.getRootProject();
            rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
        }
        return settings;
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getSettingsScript().getDisplayName(), settings.getProjectRegistry()));
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        ClassLoaderScope buildSourceClassLoaderScope = this.buildSourceBuilder.buildAndCreateClassLoader(settingsLocation.getSettingsDir(), startParameter);
        return this.settingsProcessor.process(gradle, settingsLocation, buildSourceClassLoaderScope, startParameter);
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }
}

