/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "constants", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESConstants;)V", "reduceEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "effect", "reduceEffects", "", "schema", "visitAnd", "and", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "visitConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "esConstant", "visitEqual", "equal", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "visitIs", "isOperator", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "visitNot", "not", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "visitOr", "or", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "visitReceiver", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "esVariable", "resolution"})
public final class Reducer
implements ESExpressionVisitor<ESExpression> {
    private final ESConstants constants;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ESEffect> reduceEffects(@NotNull List<? extends ESEffect> schema) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        Iterable $this$mapNotNull$iv = schema;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect eSEffect;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ESEffect it = (ESEffect)element$iv$iv;
            boolean bl2 = false;
            if (this.reduceEffect(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ESEffect it$iv$iv = eSEffect;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ESEffect reduceEffect(ESEffect effect) {
        ESEffect eSEffect = effect;
        if (eSEffect instanceof ConditionalEffect) {
            ESExpression eSExpression = (ESExpression)((ConditionalEffect)effect).getCondition().accept(this);
            if (eSExpression == null) {
                return null;
            }
            ESExpression reducedCondition = eSExpression;
            if (ValuesKt.isFalse(reducedCondition)) {
                return null;
            }
            if (ValuesKt.isTrue(reducedCondition)) {
                return ((ConditionalEffect)effect).getSimpleEffect();
            }
            return effect;
        }
        return effect;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ESExpression visitIs(@NotNull ESIs isOperator) {
        Boolean result2;
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)isOperator, (String)"isOperator");
        Object t = isOperator.getLeft().accept(this);
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        }
        ESValue reducedArg = (ESValue)t;
        ESValue eSValue = reducedArg;
        if (eSValue instanceof ESConstant) {
            bl = TypeUtilsKt.isSubtypeOf(((ESConstant)reducedArg).getType(), isOperator.getFunctor().getType());
        } else {
            if (!(eSValue instanceof ESVariable)) throw (Throwable)new IllegalStateException("Unknown ESValue: " + reducedArg);
            KotlinType kotlinType2 = reducedArg.getType();
            bl = kotlinType2 != null && TypeUtilsKt.isSubtypeOf(kotlinType2, isOperator.getFunctor().getType()) ? Boolean.valueOf(true) : null;
        }
        Boolean bl2 = result2 = bl;
        if (bl2 == null) return new ESIs(reducedArg, isOperator.getFunctor());
        bl2.booleanValue();
        return this.constants.booleanValue(result2 ^ isOperator.getFunctor().isNegated());
    }

    @Override
    @NotNull
    public ESExpression visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkParameterIsNotNull((Object)equal, (String)"equal");
        Object t = equal.getLeft().accept(this);
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        }
        ESValue reducedLeft = (ESValue)t;
        ESValue reducedRight = equal.getRight();
        if (reducedLeft instanceof ESConstant) {
            return this.constants.booleanValue(Intrinsics.areEqual((Object)reducedLeft, (Object)reducedRight) ^ equal.getFunctor().isNegated());
        }
        return new ESEqual(this.constants, reducedLeft, reducedRight, equal.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitAnd(@NotNull ESAnd and) {
        Intrinsics.checkParameterIsNotNull((Object)and, (String)"and");
        ESExpression eSExpression = (ESExpression)and.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)and.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isFalse(reducedLeft) || ValuesKt.isFalse(reducedRight) ? reducedLeft : (ValuesKt.isTrue(reducedLeft) ? reducedRight : (ValuesKt.isTrue(reducedRight) ? reducedLeft : (ESExpression)new ESAnd(this.constants, reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitOr(@NotNull ESOr or2) {
        Intrinsics.checkParameterIsNotNull((Object)or2, (String)"or");
        ESExpression eSExpression = (ESExpression)or2.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)or2.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isTrue(reducedLeft) || ValuesKt.isTrue(reducedRight) ? reducedLeft : (ValuesKt.isFalse(reducedLeft) ? reducedRight : (ValuesKt.isFalse(reducedRight) ? reducedLeft : (ESExpression)new ESOr(this.constants, reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitNot(@NotNull ESNot not) {
        Intrinsics.checkParameterIsNotNull((Object)not, (String)"not");
        ESExpression eSExpression = (ESExpression)not.getArg().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedArg = eSExpression;
        return ValuesKt.isTrue(reducedArg) ? (ESExpression)this.constants.getFalseValue() : (ValuesKt.isFalse(reducedArg) ? (ESExpression)this.constants.getTrueValue() : reducedArg);
    }

    @Override
    @NotNull
    public ESVariable visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkParameterIsNotNull((Object)esVariable, (String)"esVariable");
        return esVariable;
    }

    @Override
    @NotNull
    public ESConstant visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkParameterIsNotNull((Object)esConstant, (String)"esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkParameterIsNotNull((Object)esReceiver, (String)"esReceiver");
        return esReceiver;
    }

    public Reducer(@NotNull ESConstants constants) {
        Intrinsics.checkParameterIsNotNull((Object)constants, (String)"constants");
        this.constants = constants;
    }
}

