/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;

public abstract class AbstractMutableModuleComponentResolveMetadata
implements MutableModuleComponentResolveMetadata {
    public static final HashValue EMPTY_CONTENT = HashUtil.createHash((String)"", (String)"MD5");
    private static final String DEFAULT_STATUS = "integration";
    private final ImmutableAttributesFactory attributesFactory;
    private ModuleComponentIdentifier componentId;
    private ModuleVersionIdentifier moduleVersionId;
    private boolean changing;
    private boolean missing;
    private List<String> statusScheme = ComponentResolveMetadata.DEFAULT_STATUS_SCHEME;
    private ModuleSource moduleSource;
    private HashValue contentHash = EMPTY_CONTENT;
    private AttributeContainerInternal componentLevelAttributes;
    private final VariantMetadataRules variantMetadataRules;
    private List<MutableVariantImpl> newVariants;
    private ImmutableList<? extends ComponentVariant> variants;
    private Set<ComponentIdentifier> owners;

    protected AbstractMutableModuleComponentResolveMetadata(ImmutableAttributesFactory attributesFactory, ModuleVersionIdentifier moduleVersionId, ModuleComponentIdentifier componentIdentifier) {
        this.attributesFactory = attributesFactory;
        this.componentId = componentIdentifier;
        this.moduleVersionId = moduleVersionId;
        this.componentLevelAttributes = AbstractMutableModuleComponentResolveMetadata.defaultAttributes(attributesFactory);
        this.variantMetadataRules = new VariantMetadataRules(attributesFactory, moduleVersionId);
    }

    protected AbstractMutableModuleComponentResolveMetadata(ModuleComponentResolveMetadata metadata) {
        this.componentId = metadata.getId();
        this.moduleVersionId = metadata.getModuleVersionId();
        this.changing = metadata.isChanging();
        this.missing = metadata.isMissing();
        this.statusScheme = metadata.getStatusScheme();
        this.moduleSource = metadata.getSource();
        this.contentHash = metadata.getOriginalContentHash();
        this.variants = metadata.getVariants();
        this.attributesFactory = metadata.getAttributesFactory();
        this.componentLevelAttributes = this.attributesFactory.mutable((AttributeContainerInternal)metadata.getAttributes());
        this.variantMetadataRules = new VariantMetadataRules(this.attributesFactory, this.moduleVersionId);
        this.variantMetadataRules.setVariantDerivationStrategy(metadata.getVariantMetadataRules().getVariantDerivationStrategy());
    }

    private static AttributeContainerInternal defaultAttributes(ImmutableAttributesFactory attributesFactory) {
        return (AttributeContainerInternal)attributesFactory.mutable().attribute(ProjectInternal.STATUS_ATTRIBUTE, (Object)DEFAULT_STATUS);
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    @Override
    public void setId(ModuleComponentIdentifier componentId) {
        this.componentId = componentId;
        this.moduleVersionId = DefaultModuleVersionIdentifier.newId(componentId);
    }

    @Override
    public String getStatus() {
        return (String)this.componentLevelAttributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
    }

    protected abstract ImmutableMap<String, Configuration> getConfigurationDefinitions();

    @Override
    public void setStatus(String status) {
        AttributeContainerInternal attributes = this.componentLevelAttributes;
        attributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
        this.componentLevelAttributes = attributes;
    }

    @Override
    public List<String> getStatusScheme() {
        return this.statusScheme;
    }

    @Override
    public void setStatusScheme(List<String> statusScheme) {
        this.statusScheme = statusScheme;
    }

    @Override
    public boolean isMissing() {
        return this.missing;
    }

    @Override
    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    @Override
    public boolean isChanging() {
        return this.changing;
    }

    @Override
    public void setChanging(boolean changing) {
        this.changing = changing;
    }

    @Override
    public HashValue getContentHash() {
        return this.contentHash;
    }

    @Override
    public void setContentHash(HashValue contentHash) {
        this.contentHash = contentHash;
    }

    @Override
    public ModuleSource getSource() {
        return this.moduleSource;
    }

    @Override
    public void setSource(ModuleSource source) {
        this.moduleSource = source;
    }

    @Override
    public void setAttributes(AttributeContainer attributes) {
        this.componentLevelAttributes = this.attributesFactory.mutable((AttributeContainerInternal)attributes);
        if (!attributes.contains(ProjectInternal.STATUS_ATTRIBUTE)) {
            this.componentLevelAttributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, (Object)DEFAULT_STATUS);
        }
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.componentLevelAttributes;
    }

    @Override
    public ModuleComponentArtifactMetadata artifact(String type, @Nullable String extension, @Nullable String classifier) {
        DefaultIvyArtifactName ivyArtifactName = new DefaultIvyArtifactName(this.getModuleVersionId().getName(), type, extension, classifier);
        return new DefaultModuleComponentArtifactMetadata(this.getId(), ivyArtifactName);
    }

    @Override
    public VariantMetadataRules getVariantMetadataRules() {
        return this.variantMetadataRules;
    }

    @Override
    public MutableComponentVariant addVariant(String variantName, ImmutableAttributes attributes) {
        MutableVariantImpl variant = new MutableVariantImpl(variantName, attributes);
        if (this.newVariants == null) {
            this.newVariants = new ArrayList<MutableVariantImpl>();
        }
        this.newVariants.add(variant);
        return variant;
    }

    public ImmutableList<? extends ComponentVariant> getVariants() {
        if (this.variants == null && this.newVariants == null) {
            return ImmutableList.of();
        }
        if (this.variants != null && this.newVariants == null) {
            return this.variants;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (this.variants != null) {
            builder.addAll(this.variants);
        }
        for (MutableVariantImpl variant : this.newVariants) {
            builder.add((Object)new ImmutableVariantImpl(this.getId(), variant.name, variant.attributes, (ImmutableList<? extends ComponentVariant.Dependency>)ImmutableList.copyOf((Collection)variant.dependencies), (ImmutableList<? extends ComponentVariant.DependencyConstraint>)ImmutableList.copyOf((Collection)variant.dependencyConstraints), (ImmutableList<? extends ComponentVariant.File>)ImmutableList.copyOf((Collection)variant.files), ImmutableCapabilities.of(variant.capabilities)));
        }
        return builder.build();
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public void belongsTo(ComponentIdentifier platform) {
        if (this.owners == null) {
            this.owners = Sets.newLinkedHashSet();
        }
        this.owners.add(platform);
    }

    @Override
    public Set<? extends ComponentIdentifier> getPlatformOwners() {
        return this.owners;
    }

    protected static class ImmutableVariantImpl
    implements ComponentVariant,
    VariantResolveMetadata {
        private final ModuleComponentIdentifier componentId;
        private final String name;
        private final ImmutableAttributes attributes;
        private final ImmutableList<? extends ComponentVariant.Dependency> dependencies;
        private final ImmutableList<? extends ComponentVariant.DependencyConstraint> dependencyConstraints;
        private final ImmutableList<? extends ComponentVariant.File> files;
        private final ImmutableCapabilities capabilities;

        ImmutableVariantImpl(ModuleComponentIdentifier componentId, String name, ImmutableAttributes attributes, ImmutableList<? extends ComponentVariant.Dependency> dependencies, ImmutableList<? extends ComponentVariant.DependencyConstraint> dependencyConstraints, ImmutableList<? extends ComponentVariant.File> files, ImmutableCapabilities capabilities) {
            this.componentId = componentId;
            this.name = name;
            this.attributes = attributes;
            this.dependencies = dependencies;
            this.dependencyConstraints = dependencyConstraints;
            this.files = files;
            this.capabilities = capabilities;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)this.componentId, (Object)"variant", (Object)this.name);
        }

        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.Dependency> getDependencies() {
            return this.dependencies;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.DependencyConstraint> getDependencyConstraints() {
            return this.dependencyConstraints;
        }

        @Override
        public ImmutableList<? extends ComponentVariant.File> getFiles() {
            return this.files;
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.capabilities;
        }

        @Override
        public List<? extends ComponentArtifactMetadata> getArtifacts() {
            ArrayList<UrlBackedArtifactMetadata> artifacts = new ArrayList<UrlBackedArtifactMetadata>(this.files.size());
            for (ComponentVariant.File file : this.files) {
                artifacts.add(new UrlBackedArtifactMetadata(this.componentId, file.getName(), file.getUri()));
            }
            return artifacts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableVariantImpl that = (ImmutableVariantImpl)o;
            return Objects.equal((Object)this.componentId, (Object)that.componentId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.dependencies, that.dependencies) && Objects.equal(this.dependencyConstraints, that.dependencyConstraints) && Objects.equal(this.files, that.files);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.componentId, this.name, this.attributes, this.dependencies, this.dependencyConstraints, this.files});
        }
    }

    protected static class DependencyConstraintImpl
    implements ComponentVariant.DependencyConstraint {
        private final String group;
        private final String module;
        private final VersionConstraint versionConstraint;
        private final String reason;
        private final ImmutableAttributes attributes;

        DependencyConstraintImpl(String group, String module, VersionConstraint versionConstraint, String reason, ImmutableAttributes attributes) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.reason = reason;
            this.attributes = attributes;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getModule() {
            return this.module;
        }

        @Override
        public VersionConstraint getVersionConstraint() {
            return this.versionConstraint;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyConstraintImpl that = (DependencyConstraintImpl)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.reason, this.attributes});
        }
    }

    protected static class DependencyImpl
    implements ComponentVariant.Dependency {
        private final String group;
        private final String module;
        private final VersionConstraint versionConstraint;
        private final ImmutableList<ExcludeMetadata> excludes;
        private final String reason;
        private final ImmutableAttributes attributes;
        private final ImmutableList<Capability> requestedCapabilities;

        DependencyImpl(String group, String module, VersionConstraint versionConstraint, List<ExcludeMetadata> excludes, String reason, ImmutableAttributes attributes, List<? extends Capability> requestedCapabilities) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.excludes = ImmutableList.copyOf(excludes);
            this.reason = reason;
            this.attributes = attributes;
            this.requestedCapabilities = ImmutableList.copyOf((Collection)requestedCapabilities.stream().map(c -> new ImmutableCapability(c.getGroup(), c.getName(), c.getVersion())).collect(Collectors.toList()));
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getModule() {
            return this.module;
        }

        @Override
        public VersionConstraint getVersionConstraint() {
            return this.versionConstraint;
        }

        @Override
        public ImmutableList<ExcludeMetadata> getExcludes() {
            return this.excludes;
        }

        @Override
        public String getReason() {
            return this.reason;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public List<Capability> getRequestedCapabilities() {
            return this.requestedCapabilities;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyImpl that = (DependencyImpl)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal(this.excludes, that.excludes) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.excludes, this.reason, this.attributes});
        }
    }

    protected static class FileImpl
    implements ComponentVariant.File {
        private final String name;
        private final String uri;

        FileImpl(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUri() {
            return this.uri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileImpl file = (FileImpl)o;
            return Objects.equal((Object)this.name, (Object)file.name) && Objects.equal((Object)this.uri, (Object)file.uri);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.uri});
        }
    }

    protected static class MutableVariantImpl
    implements MutableComponentVariant {
        private final String name;
        private final ImmutableAttributes attributes;
        private final List<DependencyImpl> dependencies = Lists.newArrayList();
        private final List<DependencyConstraintImpl> dependencyConstraints = Lists.newArrayList();
        private final List<FileImpl> files = Lists.newArrayList();
        private final List<ImmutableCapability> capabilities = Lists.newArrayList();

        MutableVariantImpl(String name, ImmutableAttributes attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        @Override
        public void addDependency(String group, String module, VersionConstraint versionConstraint, List<ExcludeMetadata> excludes, String reason, ImmutableAttributes attributes, List<? extends Capability> requestedCapabilities) {
            this.dependencies.add(new DependencyImpl(group, module, versionConstraint, excludes, reason, attributes, requestedCapabilities));
        }

        @Override
        public void addDependencyConstraint(String group, String module, VersionConstraint versionConstraint, String reason, ImmutableAttributes attributes) {
            this.dependencyConstraints.add(new DependencyConstraintImpl(group, module, versionConstraint, reason, attributes));
        }

        @Override
        public void addCapability(String group, String name, String version) {
            this.capabilities.add(new ImmutableCapability(group, name, version));
        }

        @Override
        public void addFile(String name, String uri) {
            this.files.add(new FileImpl(name, uri));
        }

        public String getName() {
            return this.name;
        }
    }
}

