/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class EnumValueSnapshot
implements ValueSnapshot {
    private final String className;
    private final String name;

    public EnumValueSnapshot(Enum<?> value) {
        this.className = value.getClass().getName();
        this.name = value.name();
    }

    public EnumValueSnapshot(String className, String name) {
        this.className = className;
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        if (this.isEqualEnum(value)) {
            return this;
        }
        return snapshotter.snapshot(value);
    }

    private boolean isEqualEnum(Object value) {
        Enum enumValue;
        return value instanceof Enum && (enumValue = (Enum)value).name().equals(this.name) && enumValue.getClass().getName().equals(this.className);
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.className);
        hasher.putString((CharSequence)this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnumValueSnapshot other = (EnumValueSnapshot)obj;
        return this.className.equals(other.className) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.name.hashCode();
    }
}

