/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.util.ObservableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDestroyables;
import org.gradle.api.internal.tasks.DefaultTaskInputs;
import org.gradle.api.internal.tasks.DefaultTaskLocalState;
import org.gradle.api.internal.tasks.DefaultTaskOutputs;
import org.gradle.api.internal.tasks.ImplementationAwareTaskAction;
import org.gradle.api.internal.tasks.InputChangesAwareTaskAction;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskDestroyables;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskLocalState;
import org.gradle.internal.Factory;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.logging.compatbridge.LoggingManagerInternalCompatibilityBridge;
import org.gradle.internal.logging.slf4j.DefaultContextAwareTaskLogger;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.scripts.ScriptOrigin;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

public abstract class AbstractTask
implements TaskInternal,
DynamicObjectAware {
    private static final Logger BUILD_LOGGER = Logging.getLogger(Task.class);
    private static final ThreadLocal<TaskInfo> NEXT_INSTANCE = new ThreadLocal();
    private final TaskIdentity<?> identity;
    private final ProjectInternal project;
    private List<InputChangesAwareTaskAction> actions;
    private boolean enabled = true;
    private final DefaultTaskDependency dependencies;
    private final DefaultTaskDependency mustRunAfter;
    private final DefaultTaskDependency finalizedBy;
    private final DefaultTaskDependency shouldRunAfter;
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private String group;
    private final Property<Duration> timeout;
    private AndSpec<Task> onlyIfSpec = this.createNewOnlyIfSpec();
    private final ServiceRegistry services;
    private final TaskStateInternal state;
    private Logger logger = new DefaultContextAwareTaskLogger(BUILD_LOGGER);
    private final TaskMutator taskMutator;
    private ObservableList observableActionList;
    private boolean impliesSubProjects;
    private boolean hasCustomActions;
    private final TaskInputsInternal taskInputs;
    private final TaskOutputsInternal taskOutputs;
    private final TaskDestroyables taskDestroyables;
    private final TaskLocalStateInternal taskLocalState;
    private LoggingManagerInternal loggingManager;
    private String toStringValue;

    protected AbstractTask() {
        this(AbstractTask.taskInfo());
    }

    private static TaskInfo taskInfo() {
        return NEXT_INSTANCE.get();
    }

    private AbstractTask(TaskInfo taskInfo) {
        if (taskInfo == null) {
            throw new TaskInstantiationException(String.format("Task of type '%s' has been instantiated directly which is not supported. Tasks can only be created using the Gradle API or DSL.", this.getClass().getName()));
        }
        this.identity = taskInfo.identity;
        this.project = taskInfo.project;
        assert (this.project != null);
        assert (this.identity.name != null);
        this.state = new TaskStateInternal();
        TaskContainerInternal tasks = this.project.getTasks();
        this.mustRunAfter = new DefaultTaskDependency((TaskResolver)tasks);
        this.finalizedBy = new DefaultTaskDependency((TaskResolver)tasks);
        this.shouldRunAfter = new DefaultTaskDependency((TaskResolver)tasks);
        this.services = this.project.getServices();
        PropertyWalker propertyWalker = (PropertyWalker)this.services.get(PropertyWalker.class);
        FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)this.services.get(FileCollectionFactory.class);
        this.taskMutator = new TaskMutator(this);
        this.taskInputs = new DefaultTaskInputs(this, this.taskMutator, propertyWalker, fileCollectionFactory);
        this.taskOutputs = new DefaultTaskOutputs(this, this.taskMutator, propertyWalker, fileCollectionFactory);
        this.taskDestroyables = new DefaultTaskDestroyables(this.taskMutator);
        this.taskLocalState = new DefaultTaskLocalState(this.taskMutator);
        this.dependencies = new DefaultTaskDependency((TaskResolver)tasks, ImmutableSet.of((Object)this.taskInputs.getFiles()));
        this.timeout = this.project.getObjects().property(Duration.class);
    }

    private void assertDynamicObject() {
        if (this.extensibleDynamicObject == null) {
            this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, this.identity.type, (Instantiator)this.services.get(Instantiator.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Task> T injectIntoNewInstance(ProjectInternal project, TaskIdentity<T> identity, Callable<T> factory) {
        NEXT_INSTANCE.set(new TaskInfo(identity, project));
        try {
            Task task = (Task)GUtil.uncheckedCall(factory);
            return (T)task;
        }
        finally {
            NEXT_INSTANCE.set(null);
        }
    }

    @Override
    public TaskStateInternal getState() {
        return this.state;
    }

    public AntBuilder getAnt() {
        return this.project.getAnt();
    }

    public Project getProject() {
        return this.project;
    }

    public String getName() {
        return this.identity.name;
    }

    @Override
    public TaskIdentity<?> getTaskIdentity() {
        return this.identity;
    }

    public List<Action<? super Task>> getActions() {
        if (this.observableActionList == null) {
            this.observableActionList = new ObservableActionWrapperList(this.getTaskActions());
            this.observableActionList.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractTask.this.taskMutator.assertMutable("Task.getActions()", evt);
                }
            });
        }
        return this.observableActionList;
    }

    @Override
    public List<InputChangesAwareTaskAction> getTaskActions() {
        if (this.actions == null) {
            this.actions = new ArrayList<InputChangesAwareTaskAction>(3);
        }
        return this.actions;
    }

    @Override
    public boolean hasTaskActions() {
        return this.actions != null && !this.actions.isEmpty();
    }

    public void setActions(final List<Action<? super Task>> replacements) {
        this.taskMutator.mutate("Task.setActions(List<Action>)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().clear();
                for (Action action : replacements) {
                    AbstractTask.this.doLast((Action<? super Task>)action);
                }
            }
        });
    }

    public TaskDependencyInternal getTaskDependencies() {
        return this.dependencies;
    }

    public Set<Object> getDependsOn() {
        return this.dependencies.getMutableValues();
    }

    public void setDependsOn(final Iterable<?> dependsOn) {
        this.taskMutator.mutate("Task.setDependsOn(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.dependencies.setValues(dependsOn);
            }
        });
    }

    public void onlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.onlyIf(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(onlyIfClosure);
            }
        });
    }

    public void onlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.onlyIf(Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.onlyIfSpec.and(spec);
            }
        });
    }

    public void setOnlyIf(final Spec<? super Task> spec) {
        this.taskMutator.mutate("Task.setOnlyIf(Spec)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(spec);
            }
        });
    }

    public void setOnlyIf(final Closure onlyIfClosure) {
        this.taskMutator.mutate("Task.setOnlyIf(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.onlyIfSpec = AbstractTask.this.createNewOnlyIfSpec().and(onlyIfClosure);
            }
        });
    }

    private AndSpec<Task> createNewOnlyIfSpec() {
        return new AndSpec(new Spec[]{new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return element == AbstractTask.this && AbstractTask.this.enabled;
            }
        }});
    }

    @Override
    public Spec<? super TaskInternal> getOnlyIf() {
        return this.onlyIfSpec;
    }

    public boolean getDidWork() {
        return this.state.getDidWork();
    }

    public void setDidWork(boolean didWork) {
        this.state.setDidWork(didWork);
    }

    @Internal
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.taskMutator.mutate("Task.setEnabled(boolean)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.enabled = enabled;
            }
        });
    }

    @Override
    public boolean getImpliesSubProjects() {
        return this.impliesSubProjects;
    }

    @Override
    public void setImpliesSubProjects(boolean impliesSubProjects) {
        this.impliesSubProjects = impliesSubProjects;
    }

    public String getPath() {
        return this.identity.projectPath.toString();
    }

    @Override
    public Path getIdentityPath() {
        return this.identity.identityPath;
    }

    public Task dependsOn(final Object ... paths) {
        this.taskMutator.mutate("Task.dependsOn(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.dependencies.add(paths);
            }
        });
        return this;
    }

    public Task doFirst(Action<? super Task> action) {
        return this.doFirst("doFirst {} action", action);
    }

    public Task doFirst(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Action)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.wrap((Action<? super Task>)action, actionName));
            }
        });
        return this;
    }

    public Task doLast(Action<? super Task> action) {
        return this.doLast("doLast {} action", action);
    }

    public Task doLast(final String actionName, final Action<? super Task> action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Action)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.wrap((Action<? super Task>)action, actionName));
            }
        });
        return this;
    }

    public int compareTo(Task otherTask) {
        int depthCompare = this.project.compareTo(otherTask.getProject());
        if (depthCompare == 0) {
            return this.getPath().compareTo(otherTask.getPath());
        }
        return depthCompare;
    }

    public String toString() {
        if (this.toStringValue == null) {
            this.toStringValue = "task '" + this.getIdentityPath() + "'";
        }
        return this.toStringValue;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggingManagerInternal getLogging() {
        if (this.loggingManager == null) {
            this.loggingManager = new LoggingManagerInternalCompatibilityBridge((org.gradle.internal.logging.LoggingManagerInternal)this.services.getFactory(org.gradle.internal.logging.LoggingManagerInternal.class).create());
        }
        return this.loggingManager;
    }

    @Override
    public void replaceLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    public Object property(String propertyName) throws MissingPropertyException {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    public boolean hasProperty(String propertyName) {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    public void setProperty(String name, Object value) {
        this.assertDynamicObject();
        this.extensibleDynamicObject.setProperty(name, value);
    }

    public Convention getConvention() {
        this.assertDynamicObject();
        return this.extensibleDynamicObject.getConvention();
    }

    @Internal
    public ExtensionContainer getExtensions() {
        return this.getConvention();
    }

    @Internal
    public DynamicObject getAsDynamicObject() {
        this.assertDynamicObject();
        return this.extensibleDynamicObject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public TaskInputsInternal getInputs() {
        return this.taskInputs;
    }

    @Override
    public TaskOutputsInternal getOutputs() {
        return this.taskOutputs;
    }

    public TaskDestroyables getDestroyables() {
        return this.taskDestroyables;
    }

    public TaskLocalState getLocalState() {
        return this.taskLocalState;
    }

    @Internal
    protected ServiceRegistry getServices() {
        return this.services;
    }

    public Task doFirst(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doFirst(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(0, AbstractTask.this.convertClosureToAction(action, "doFirst {} action"));
            }
        });
        return this;
    }

    public Task doLast(final Closure action) {
        this.hasCustomActions = true;
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.taskMutator.mutate("Task.doLast(Closure)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.getTaskActions().add(AbstractTask.this.convertClosureToAction(action, "doLast {} action"));
            }
        });
        return this;
    }

    public Task configure(Closure closure) {
        return (Task)ConfigureUtil.configureSelf((Closure)closure, (Object)this);
    }

    public File getTemporaryDir() {
        File dir = ((TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class)).newTemporaryFile(this.getName());
        GFileUtils.mkdirs((File)dir);
        return dir;
    }

    @Override
    public Factory<File> getTemporaryDirFactory() {
        return new Factory<File>(){

            public File create() {
                return AbstractTask.this.getTemporaryDir();
            }
        };
    }

    private InputChangesAwareTaskAction convertClosureToAction(Closure actionClosure, String actionName) {
        return new ClosureTaskAction(actionClosure, actionName);
    }

    private InputChangesAwareTaskAction wrap(Action<? super Task> action) {
        return this.wrap(action, "unnamed action");
    }

    private InputChangesAwareTaskAction wrap(Action<? super Task> action, String actionName) {
        if (action instanceof InputChangesAwareTaskAction) {
            return (InputChangesAwareTaskAction)action;
        }
        return new TaskActionWrapper(action, actionName);
    }

    private static String getActionClassName(Object action) {
        if (action instanceof ScriptOrigin) {
            ScriptOrigin origin = (ScriptOrigin)action;
            return origin.getOriginalClassName() + "_" + origin.getContentHash();
        }
        return action.getClass().getName();
    }

    public void setMustRunAfter(final Iterable<?> mustRunAfterTasks) {
        this.taskMutator.mutate("Task.setMustRunAfter(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.mustRunAfter.setValues(mustRunAfterTasks);
            }
        });
    }

    public Task mustRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.mustRunAfter(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.mustRunAfter.add(paths);
            }
        });
        return this;
    }

    public TaskDependency getMustRunAfter() {
        return this.mustRunAfter;
    }

    public void setFinalizedBy(final Iterable<?> finalizedByTasks) {
        this.taskMutator.mutate("Task.setFinalizedBy(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.finalizedBy.setValues(finalizedByTasks);
            }
        });
    }

    public Task finalizedBy(final Object ... paths) {
        this.taskMutator.mutate("Task.finalizedBy(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.finalizedBy.add(paths);
            }
        });
        return this;
    }

    public TaskDependency getFinalizedBy() {
        return this.finalizedBy;
    }

    public TaskDependency shouldRunAfter(final Object ... paths) {
        this.taskMutator.mutate("Task.shouldRunAfter(Object...)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.shouldRunAfter.add(paths);
            }
        });
        return this.shouldRunAfter;
    }

    public void setShouldRunAfter(final Iterable<?> shouldRunAfterTasks) {
        this.taskMutator.mutate("Task.setShouldRunAfter(Iterable)", new Runnable(){

            @Override
            public void run() {
                AbstractTask.this.shouldRunAfter.setValues(shouldRunAfterTasks);
            }
        });
    }

    public TaskDependency getShouldRunAfter() {
        return this.shouldRunAfter;
    }

    @Override
    public void prependParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(0, this.wrap(action));
    }

    @Override
    public void appendParallelSafeAction(Action<? super Task> action) {
        if (action == null) {
            throw new InvalidUserDataException("Action must not be null!");
        }
        this.getTaskActions().add(this.wrap(action));
    }

    @Override
    public boolean isHasCustomActions() {
        return this.hasCustomActions;
    }

    public Property<Duration> getTimeout() {
        return this.timeout;
    }

    private class ObservableActionWrapperList
    extends ObservableList {
        public ObservableActionWrapperList(List delegate) {
            super(delegate);
        }

        public boolean add(Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            return super.add((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public void add(int index, Object action) {
            if (action == null) {
                throw new InvalidUserDataException("Action must not be null!");
            }
            super.add(index, (Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        public boolean addAll(Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean addAll(int index, Collection actions) {
            if (actions == null) {
                throw new InvalidUserDataException("Actions must not be null!");
            }
            return super.addAll(index, this.transformToContextAwareTaskActions(actions));
        }

        public boolean removeAll(Collection actions) {
            return super.removeAll(this.transformToContextAwareTaskActions(actions));
        }

        public boolean remove(Object action) {
            return super.remove((Object)AbstractTask.this.wrap((Action<? super Task>)((Action)action)));
        }

        private Collection<InputChangesAwareTaskAction> transformToContextAwareTaskActions(Collection<Object> c) {
            return Collections2.transform(c, (Function)new Function<Object, InputChangesAwareTaskAction>(){

                public InputChangesAwareTaskAction apply(@Nullable Object input) {
                    return AbstractTask.this.wrap((Action<? super Task>)((Action)input));
                }
            });
        }
    }

    private static class TaskActionWrapper
    implements InputChangesAwareTaskAction {
        private final Action<? super Task> action;
        private final String maybeActionName;

        public TaskActionWrapper(Action<? super Task> action, String maybeActionName) {
            this.action = action;
            this.maybeActionName = maybeActionName;
        }

        @Override
        public void setInputChanges(InputChangesInternal inputChanges) {
            if (this.action instanceof InputChangesAwareTaskAction) {
                ((InputChangesAwareTaskAction)this.action).setInputChanges(inputChanges);
            }
        }

        @Override
        public void clearInputChanges() {
            if (this.action instanceof InputChangesAwareTaskAction) {
                ((InputChangesAwareTaskAction)this.action).clearInputChanges();
            }
        }

        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute((Object)task);
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        @Override
        public ImplementationSnapshot getActionImplementation(ClassLoaderHierarchyHasher hasher) {
            if (this.action instanceof ImplementationAwareTaskAction) {
                return ((ImplementationAwareTaskAction)this.action).getActionImplementation(hasher);
            }
            return ImplementationSnapshot.of((String)AbstractTask.getActionClassName(this.action), (HashCode)hasher.getClassLoaderHash(this.action.getClass().getClassLoader()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TaskActionWrapper)) {
                return false;
            }
            TaskActionWrapper that = (TaskActionWrapper)o;
            return !(this.action != null ? !this.action.equals(that.action) : that.action != null);
        }

        public int hashCode() {
            return this.action != null ? this.action.hashCode() : 0;
        }

        public String getDisplayName() {
            if (this.action instanceof Describable) {
                return ((Describable)this.action).getDisplayName();
            }
            return "Execute " + this.maybeActionName;
        }
    }

    private static class ClosureTaskAction
    implements InputChangesAwareTaskAction {
        private final Closure closure;
        private final String actionName;

        private ClosureTaskAction(Closure closure, String actionName) {
            this.closure = closure;
            this.actionName = actionName;
        }

        @Override
        public void setInputChanges(InputChangesInternal inputChanges) {
        }

        @Override
        public void clearInputChanges() {
        }

        public void execute(Task task) {
            this.closure.setDelegate((Object)task);
            this.closure.setResolveStrategy(1);
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.closure.getClass().getClassLoader());
            try {
                if (this.closure.getMaximumNumberOfParameters() == 0) {
                    this.closure.call();
                } else {
                    this.closure.call((Object)task);
                }
            }
            catch (InvokerInvocationException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        @Override
        public ImplementationSnapshot getActionImplementation(ClassLoaderHierarchyHasher hasher) {
            return ImplementationSnapshot.of((String)AbstractTask.getActionClassName(this.closure), (HashCode)hasher.getClassLoaderHash(this.closure.getClass().getClassLoader()));
        }

        public String getDisplayName() {
            return "Execute " + this.actionName;
        }
    }

    private static class TaskInfo {
        private final TaskIdentity<?> identity;
        private final ProjectInternal project;

        private TaskInfo(TaskIdentity<?> identity, ProjectInternal project) {
            this.identity = identity;
            this.project = project;
        }
    }
}

