/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.ContinuousExecutionGate;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileWatcherEventListener;

class DefaultGatedChangeWaiter
implements FileSystemChangeWaiter {
    private final FileSystemChangeWaiter delegate;
    private final BuildCancellationToken cancellationToken;
    private final ContinuousExecutionGate continuousExecutionGate;

    DefaultGatedChangeWaiter(FileSystemChangeWaiter delegate, BuildCancellationToken cancellationToken, ContinuousExecutionGate continuousExecutionGate) {
        this.delegate = delegate;
        this.cancellationToken = cancellationToken;
        this.continuousExecutionGate = continuousExecutionGate;
    }

    @Override
    public void watch(FileSystemSubset fileSystemSubset) {
        this.delegate.watch(fileSystemSubset);
    }

    @Override
    public void wait(Runnable notifier, FileWatcherEventListener eventListener) {
        this.delegate.wait(notifier, eventListener);
        if (!this.cancellationToken.isCancellationRequested()) {
            this.continuousExecutionGate.waitForOpen();
        }
    }

    @Override
    public boolean isWatching() {
        return this.delegate.isWatching();
    }

    public void stop() {
        this.delegate.stop();
    }
}

