/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.NewKotlinTypeCheckerKt;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckerContext;
import org.jetbrains.annotations.NotNull;

public final class NullabilityChecker {
    public static final NullabilityChecker INSTANCE;

    public final boolean isPossibleSubtype(@NotNull TypeCheckerContext context, @NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return this.runIsPossibleSubtype(context, subType, superType);
    }

    public final boolean isSubtypeOfAny(@NotNull UnwrappedType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.hasNotNullSupertype(new TypeCheckerContext(false, false, 2, null), FlexibleTypesKt.lowerIfFlexible(type2), TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE);
    }

    private final boolean runIsPossibleSubtype(@NotNull TypeCheckerContext $this$runIsPossibleSubtype, SimpleType subType, SimpleType superType) {
        boolean bl = NewKotlinTypeCheckerKt.isIntersectionType(subType) || NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || $this$runIsPossibleSubtype.isAllowedTypeVariable(subType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NullabilityChecker$runIsPossibleSubtype$32 = false;
            String $i$a$-assert-NullabilityChecker$runIsPossibleSubtype$32 = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-NullabilityChecker$runIsPossibleSubtype$32));
        }
        bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $this$runIsPossibleSubtype.isAllowedTypeVariable(superType);
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (superType.isMarkedNullable()) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(subType)) {
            return true;
        }
        if (this.hasNotNullSupertype($this$runIsPossibleSubtype, subType, TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(superType)) {
            return false;
        }
        if (this.hasNotNullSupertype($this$runIsPossibleSubtype, superType, TypeCheckerContext.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if (NewKotlinTypeCheckerKt.isClassType(subType)) {
            return false;
        }
        return this.hasPathByNotMarkedNullableNodes($this$runIsPossibleSubtype, subType, superType.getConstructor());
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasNotNullSupertype(@NotNull TypeCheckerContext $this$hasNotNullSupertype, SimpleType type, TypeCheckerContext.SupertypesPolicy supertypesPolicy) {
        block9: {
            this_$iv = $this$hasNotNullSupertype;
            $i$f$anySupertype$descriptors = false;
            it = type;
            $i$a$-anySupertype-NullabilityChecker$hasNotNullSupertype$1 = false;
            if (NewKotlinTypeCheckerKt.isClassType(it) != false && it.isMarkedNullable() == false || SpecialTypesKt.isDefinitelyNotNullType(it) != false) {
                v0 = true;
            } else {
                TypeCheckerContext.access$initialize(this_$iv);
                v1 = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                deque$iv = v1;
                v2 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                visitedSupertypes$iv = v2;
                deque$iv.push(type);
                block0: while (true) {
                    var10_10 = deque$iv;
                    var11_11 = false;
                    if (!(var10_10.isEmpty() == false)) break;
                    if (visitedSupertypes$iv.size() > 1000) {
                        var10_10 = "Too many supertypes for type: " + type + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        var11_11 = false;
                        throw (Throwable)new IllegalStateException(var10_10.toString());
                    }
                    v3 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"current");
                    if (!visitedSupertypes$iv.add(v3)) continue;
                    it = current$iv;
                    $i$a$-anySupertype-NullabilityChecker$hasNotNullSupertype$2 = false;
                    var12_13 = it.isMarkedNullable() != false ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    var13_14 = false;
                    var14_16 = false;
                    it$iv = var12_13;
                    $i$a$-takeIf-TypeCheckerContext$anySupertype$policy$1 = false;
                    if (((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true) != false ? var12_13 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    var13_15 = current$iv.getConstructor().getSupertypes().iterator();
                    while (true) {
                        if (var13_15.hasNext()) ** break;
                        continue block0;
                        v4 = supertype$iv = var13_15.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(v4);
                        $i$a$-anySupertype-NullabilityChecker$hasNotNullSupertype$1 = false;
                        if (NewKotlinTypeCheckerKt.isClassType(it) != false && it.isMarkedNullable() == false || SpecialTypesKt.isDefinitelyNotNullType(it) != false) {
                            TypeCheckerContext.access$clear(this_$iv);
                            v0 = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                    break;
                }
                TypeCheckerContext.access$clear(this_$iv);
                v0 = false;
            }
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerContext $this$hasPathByNotMarkedNullableNodes, SimpleType start, TypeConstructor end) {
        block9: {
            this_$iv = $this$hasPathByNotMarkedNullableNodes;
            $i$f$anySupertype$descriptors = false;
            it = start;
            $i$a$-anySupertype-NullabilityChecker$hasPathByNotMarkedNullableNodes$1 = false;
            if (it.isMarkedNullable() == false && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end) != false) {
                v0 = true;
            } else {
                TypeCheckerContext.access$initialize(this_$iv);
                v1 = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                deque$iv = v1;
                v2 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                visitedSupertypes$iv = v2;
                deque$iv.push(start);
                block0: while (true) {
                    var10_10 = deque$iv;
                    var11_11 = false;
                    if (!(var10_10.isEmpty() == false)) break;
                    if (visitedSupertypes$iv.size() > 1000) {
                        var10_10 = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        var11_11 = false;
                        throw (Throwable)new IllegalStateException(var10_10.toString());
                    }
                    v3 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"current");
                    if (!visitedSupertypes$iv.add(v3)) continue;
                    it = current$iv;
                    $i$a$-anySupertype-NullabilityChecker$hasPathByNotMarkedNullableNodes$2 = false;
                    var12_13 = it.isMarkedNullable() != false ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    var13_14 = false;
                    var14_16 = false;
                    it$iv = var12_13;
                    $i$a$-takeIf-TypeCheckerContext$anySupertype$policy$1 = false;
                    if (((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true) != false ? var12_13 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    var13_15 = current$iv.getConstructor().getSupertypes().iterator();
                    while (true) {
                        if (var13_15.hasNext()) ** break;
                        continue block0;
                        v4 = supertype$iv = var13_15.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(v4);
                        $i$a$-anySupertype-NullabilityChecker$hasPathByNotMarkedNullableNodes$1 = false;
                        if (it.isMarkedNullable() == false && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end) != false) {
                            TypeCheckerContext.access$clear(this_$iv);
                            v0 = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                    break;
                }
                TypeCheckerContext.access$clear(this_$iv);
                v0 = false;
            }
        }
        return v0;
    }

    private NullabilityChecker() {
    }

    static {
        NullabilityChecker nullabilityChecker;
        INSTANCE = nullabilityChecker = new NullabilityChecker();
    }
}

