/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "InnerClassTransformer", "ir.backend.common"})
public final class InnerClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        new InnerClassTransformer(irClass).lowerInnerClass();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassesLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0003*\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering$InnerClassTransformer;", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesLowering;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "oldConstructorParameterToNew", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getOldConstructorParameterToNew", "()Ljava/util/HashMap;", "outerThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getOuterThisField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "setOuterThisField", "(Lorg/jetbrains/kotlin/ir/declarations/IrField;)V", "createOuterThisField", "", "lowerConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "irConstructor", "lowerConstructorParameterUsages", "lowerConstructors", "lowerInnerClass", "lowerOuterThisReferences", "getClassForImplicitThis", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "ir.backend.common"})
    private final class InnerClassTransformer {
        @NotNull
        public IrField outerThisField;
        @NotNull
        private final HashMap<IrValueParameter, IrValueParameter> oldConstructorParameterToNew;
        @NotNull
        private final IrClass irClass;

        @NotNull
        public final IrField getOuterThisField() {
            IrField irField = this.outerThisField;
            if (irField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outerThisField");
            }
            return irField;
        }

        public final void setOuterThisField(@NotNull IrField irField) {
            Intrinsics.checkParameterIsNotNull((Object)irField, (String)"<set-?>");
            this.outerThisField = irField;
        }

        @NotNull
        public final HashMap<IrValueParameter, IrValueParameter> getOldConstructorParameterToNew() {
            return this.oldConstructorParameterToNew;
        }

        public final void lowerInnerClass() {
            if (!this.irClass.isInner()) {
                return;
            }
            this.createOuterThisField();
            this.lowerConstructors();
            this.lowerConstructorParameterUsages();
            this.lowerOuterThisReferences();
        }

        private final void createOuterThisField() {
            IrField field;
            this.outerThisField = field = InnerClassesLowering.this.getContext().getDeclarationFactory().getOuterThisField(this.irClass);
            Collection collection = this.irClass.getDeclarations();
            boolean bl = false;
            collection.add(field);
        }

        private final void lowerConstructors() {
            TransformKt.transformDeclarationsFlat(this.irClass, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)new Function1<IrDeclaration, List<? extends IrDeclaration>>(this){
                final /* synthetic */ InnerClassTransformer this$0;

                @Nullable
                public final List<IrDeclaration> invoke(@NotNull IrDeclaration irMember) {
                    Intrinsics.checkParameterIsNotNull((Object)irMember, (String)"irMember");
                    return irMember instanceof IrConstructor ? CollectionsKt.listOf((Object)InnerClassTransformer.access$lowerConstructor(this.this$0, (IrConstructor)irMember)) : null;
                }
                {
                    this.this$0 = innerClassTransformer;
                    super(1);
                }
            }));
        }

        private final IrConstructor lowerConstructor(IrConstructor irConstructor) {
            int n;
            Object object;
            IrBlockBody blockBody;
            IrValueParameterSymbol outerThisValueParameter;
            IrConstructor loweredConstructor;
            int endOffset;
            int startOffset;
            block11: {
                startOffset = irConstructor.getStartOffset();
                endOffset = irConstructor.getEndOffset();
                loweredConstructor = InnerClassesLowering.this.getContext().getDeclarationFactory().getInnerClassConstructorWithOuterThisParameter(irConstructor);
                outerThisValueParameter = (IrValueParameterSymbol)loweredConstructor.getValueParameters().get(0).getSymbol();
                Iterable $this$forEach$iv = irConstructor.getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrValueParameter old = (IrValueParameter)element$iv;
                    boolean bl = false;
                    ((Map)this.oldConstructorParameterToNew).put(old, loweredConstructor.getValueParameters().get(old.getIndex() + 1));
                }
                IrBody irBody = irConstructor.getBody();
                if (!(irBody instanceof IrBlockBody)) {
                    irBody = null;
                }
                IrBlockBody irBlockBody2 = (IrBlockBody)irBody;
                if (irBlockBody2 == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + irConstructor.getBody())));
                }
                blockBody = irBlockBody2;
                List<IrStatement> $this$indexOfFirst$iv = blockBody.getStatements();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                object = $this$indexOfFirst$iv.iterator();
                while (object.hasNext()) {
                    IrStatement item$iv;
                    IrStatement it = item$iv = object.next();
                    boolean bl = false;
                    if (it instanceof IrInstanceInitializerCall) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int instanceInitializerIndex = n;
            List<IrStatement> list2 = blockBody.getStatements();
            IrField irField = this.outerThisField;
            if (irField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outerThisField");
            }
            IrFieldSymbol irFieldSymbol = (IrFieldSymbol)irField.getSymbol();
            IrValueParameter irValueParameter = this.irClass.getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            list2.add(0, new IrSetFieldImpl(startOffset, endOffset, irFieldSymbol, (IrExpression)new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null), (IrExpression)new IrGetValueImpl(startOffset, endOffset, outerThisValueParameter, null, 8, null), InnerClassesLowering.this.getContext().getIrBuiltIns().getUnitType(), null, null, 192, null));
            if (instanceInitializerIndex < 0) {
                Object v7;
                block12: {
                    Iterable iterable = blockBody.getStatements();
                    boolean bl = false;
                    object = iterable;
                    boolean bl2 = false;
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        IrStatement it = (IrStatement)t;
                        boolean bl3 = false;
                        if (!(it instanceof IrDelegatingConstructorCall)) continue;
                        v7 = t;
                        break block12;
                    }
                    v7 = null;
                }
                IrStatement irStatement = v7;
                if (irStatement == null) {
                    throw (Throwable)((Object)new AssertionError((Object)("Delegating constructor call expected: " + DumpIrTreeKt.dump(irConstructor))));
                }
                if (irStatement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall");
                }
                IrDelegatingConstructorCall delegatingConstructorCall = (IrDelegatingConstructorCall)irStatement;
                delegatingConstructorCall.setDispatchReceiver(new IrGetValueImpl(delegatingConstructorCall.getStartOffset(), delegatingConstructorCall.getEndOffset(), outerThisValueParameter, null, 8, null));
            }
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)blockBody, loweredConstructor);
            loweredConstructor.setBody(blockBody);
            return loweredConstructor;
        }

        private final void lowerConstructorParameterUsages() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new VariableRemapper((Map<IrValueParameter, ? extends IrValueParameter>)this.oldConstructorParameterToNew));
        }

        private final void lowerOuterThisReferences() {
            IrElementTransformerVoidKt.transformChildrenVoid(this.irClass, new IrElementTransformerVoid(this){
                final /* synthetic */ InnerClassTransformer this$0;

                @NotNull
                public IrStatement visitClass(@NotNull IrClass declaration) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                    return declaration;
                }

                @NotNull
                public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    IrClass irClass = InnerClassTransformer.access$getClassForImplicitThis(this.this$0, expression2.getSymbol());
                    if (irClass == null) {
                        return expression2;
                    }
                    IrClass implicitThisClass = irClass;
                    if (Intrinsics.areEqual((Object)implicitThisClass, (Object)this.this$0.getIrClass())) {
                        return expression2;
                    }
                    int startOffset = expression2.getStartOffset();
                    int endOffset = expression2.getEndOffset();
                    IrStatementOrigin origin = expression2.getOrigin();
                    IrValueParameter irValueParameter = this.this$0.getIrClass().getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    IrExpression irThis = new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)irValueParameter.getSymbol(), origin);
                    IrClass innerClass = this.this$0.getIrClass();
                    while (Intrinsics.areEqual((Object)innerClass, (Object)implicitThisClass) ^ true) {
                        if (!innerClass.isInner()) {
                            return expression2;
                        }
                        IrField outerThisField = this.this$0.InnerClassesLowering.this.getContext().getDeclarationFactory().getOuterThisField(innerClass);
                        irThis = new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)outerThisField.getSymbol(), outerThisField.getType(), irThis, origin, null, 64, null);
                        IrDeclarationParent outer = innerClass.getParent();
                        IrDeclarationParent irDeclarationParent = outer;
                        if (!(irDeclarationParent instanceof IrClass)) {
                            irDeclarationParent = null;
                        }
                        if ((IrClass)irDeclarationParent != null) continue;
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected containing declaration for inner class " + innerClass + ": " + outer)));
                    }
                    return irThis;
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final IrClass getClassForImplicitThis(@NotNull IrValueSymbol $this$getClassForImplicitThis) {
            IrValueParameter declaration;
            if ($this$getClassForImplicitThis instanceof IrValueParameterSymbol && (declaration = (IrValueParameter)((IrValueParameterSymbol)$this$getClassForImplicitThis).getOwner()).getIndex() == -1 && declaration.getName().isSpecial()) {
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(((IrValueParameter)((IrValueParameterSymbol)$this$getClassForImplicitThis).getOwner()).getType());
                IrSymbolOwner irSymbolOwner = irClassifierSymbol != null ? irClassifierSymbol.getOwner() : null;
                if (irSymbolOwner == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                return (IrClass)irSymbolOwner;
            }
            return null;
        }

        @NotNull
        public final IrClass getIrClass() {
            return this.irClass;
        }

        public InnerClassTransformer(@NotNull IrClass irClass) {
            Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
            this.irClass = irClass;
            this.oldConstructorParameterToNew = new HashMap();
        }

        public static final /* synthetic */ IrConstructor access$lowerConstructor(InnerClassTransformer $this, IrConstructor irConstructor) {
            return $this.lowerConstructor(irConstructor);
        }

        public static final /* synthetic */ IrClass access$getClassForImplicitThis(InnerClassTransformer $this, IrValueSymbol $this$access_u24getClassForImplicitThis) {
            return $this.getClassForImplicitThis($this$access_u24getClassForImplicitThis);
        }
    }
}

