/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Collection;
import org.gradle.api.internal.classloading.GroovySystemLoader;
import org.gradle.api.internal.classloading.GroovySystemLoaderFactory;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.internal.AbstractClassLoaderWorker;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DefaultWorkResult;

public class IsolatedClassloaderWorker
extends AbstractClassLoaderWorker {
    private final GroovySystemLoaderFactory groovySystemLoaderFactory = new GroovySystemLoaderFactory();
    private final ClassLoaderStructure classLoaderStructure;
    private final ClassLoader workerInfrastructureClassloader;
    private final ServiceRegistry serviceRegistry;
    private ClassLoader workerClassLoader;
    private boolean reuseClassloader;

    public IsolatedClassloaderWorker(ClassLoaderStructure classLoaderStructure, ClassLoader workerInfrastructureClassloader, ServiceRegistry serviceRegistry) {
        super(serviceRegistry);
        this.classLoaderStructure = classLoaderStructure;
        this.workerInfrastructureClassloader = workerInfrastructureClassloader;
        this.serviceRegistry = serviceRegistry;
    }

    public IsolatedClassloaderWorker(ClassLoaderStructure classLoaderStructure, ClassLoader workerInfrastructureClassloader, ServiceRegistry serviceRegistry, boolean reuseClassloader) {
        this(classLoaderStructure, workerInfrastructureClassloader, serviceRegistry);
        this.reuseClassloader = reuseClassloader;
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        DefaultWorkResult defaultWorkResult;
        ClassLoader workerClassLoader = this.getWorkerClassLoader();
        GroovySystemLoader workerClasspathGroovy = this.groovySystemLoaderFactory.forClassLoader(workerClassLoader);
        try {
            defaultWorkResult = this.executeInClassLoader(spec, workerClassLoader);
        }
        catch (Exception e) {
            try {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
            catch (Throwable throwable) {
                workerClasspathGroovy.shutdown();
                if (!this.reuseClassloader) {
                    CompositeStoppable.stoppable((Object[])new Object[]{workerClassLoader}).stop();
                    this.workerClassLoader = null;
                }
                throw throwable;
            }
        }
        workerClasspathGroovy.shutdown();
        if (!this.reuseClassloader) {
            CompositeStoppable.stoppable((Object[])new Object[]{workerClassLoader}).stop();
            this.workerClassLoader = null;
        }
        return defaultWorkResult;
    }

    private ClassLoader getWorkerClassLoader() {
        if (this.workerClassLoader == null) {
            this.workerClassLoader = this.createWorkerClassloader();
        }
        return this.workerClassLoader;
    }

    private ClassLoader createWorkerClassloader() {
        if (this.classLoaderStructure == null) {
            throw new IllegalStateException("ClassLoaderStructure cannot be null");
        }
        return this.createWorkerClassLoaderWithStructure(this.workerInfrastructureClassloader, this.classLoaderStructure);
    }

    private ClassLoader createWorkerClassLoaderWithStructure(ClassLoader workerInfrastructureClassloader, ClassLoaderStructure classLoaderStructure) {
        if (classLoaderStructure.getParent() == null) {
            return this.createClassLoaderFromSpec(workerInfrastructureClassloader, classLoaderStructure.getSpec());
        }
        ClassLoader parent = this.createWorkerClassLoaderWithStructure(workerInfrastructureClassloader, classLoaderStructure.getParent());
        return this.createClassLoaderFromSpec(parent, classLoaderStructure.getSpec());
    }

    private ClassLoader createClassLoaderFromSpec(ClassLoader parent, ClassLoaderSpec spec) {
        if (spec instanceof MixInLegacyTypesClassLoader.Spec) {
            MixInLegacyTypesClassLoader.Spec mixinSpec = (MixInLegacyTypesClassLoader.Spec)spec;
            if (mixinSpec.getClasspath().isEmpty()) {
                return parent;
            }
            return new MixInLegacyTypesClassLoader(parent, (Collection)mixinSpec.getClasspath(), (LegacyTypesSupport)this.serviceRegistry.get(LegacyTypesSupport.class));
        }
        if (spec instanceof VisitableURLClassLoader.Spec) {
            VisitableURLClassLoader.Spec visitableSpec = (VisitableURLClassLoader.Spec)spec;
            if (visitableSpec.getClasspath().isEmpty()) {
                return parent;
            }
            return new VisitableURLClassLoader(visitableSpec.getName(), parent, (Collection)visitableSpec.getClasspath());
        }
        if (spec instanceof FilteringClassLoader.Spec) {
            FilteringClassLoader.Spec filteringSpec = (FilteringClassLoader.Spec)spec;
            if (filteringSpec.isEmpty()) {
                return parent;
            }
            return new FilteringClassLoader(parent, filteringSpec);
        }
        throw new IllegalArgumentException("Can't handle spec of type " + spec.getClass().getName());
    }
}

