/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.Interner;
import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileMetadataSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemMirror;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemSnapshotter;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotter;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotFilter;

public class DefaultFileSystemSnapshotter
implements FileSystemSnapshotter {
    private final FileHasher hasher;
    private final Interner<String> stringInterner;
    private final Stat stat;
    private final FileSystemMirror fileSystemMirror;
    private final StripedProducerGuard<String> producingSnapshots = new StripedProducerGuard();
    private final DirectorySnapshotter directorySnapshotter;

    public DefaultFileSystemSnapshotter(FileHasher hasher, Interner<String> stringInterner, Stat stat, FileSystemMirror fileSystemMirror, String ... defaultExcludes) {
        this.hasher = hasher;
        this.stringInterner = stringInterner;
        this.stat = stat;
        this.fileSystemMirror = fileSystemMirror;
        this.directorySnapshotter = new DirectorySnapshotter(hasher, stringInterner, defaultExcludes);
    }

    @Override
    public HashCode getRegularFileContentHash(final File file) {
        final String absolutePath = file.getAbsolutePath();
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(absolutePath);
        if (metadata != null) {
            if (metadata.getType() != FileType.RegularFile) {
                return null;
            }
            FileSystemLocationSnapshot snapshot = this.fileSystemMirror.getSnapshot(absolutePath);
            if (snapshot != null) {
                return snapshot.getHash();
            }
        }
        return this.producingSnapshots.guardByKey(absolutePath, new Supplier<HashCode>(){

            @Override
            @Nullable
            public HashCode get() {
                InternableString internableAbsolutePath = new InternableString(absolutePath);
                FileMetadataSnapshot metadata = DefaultFileSystemSnapshotter.this.statAndCache(internableAbsolutePath, file);
                if (metadata.getType() != FileType.RegularFile) {
                    return null;
                }
                FileSystemLocationSnapshot snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(internableAbsolutePath, file, metadata, null);
                return snapshot.getHash();
            }
        });
    }

    @Override
    public FileSystemLocationSnapshot snapshot(final File file) {
        String absolutePath = file.getAbsolutePath();
        FileSystemLocationSnapshot result = this.fileSystemMirror.getSnapshot(absolutePath);
        if (result == null) {
            result = this.producingSnapshots.guardByKey(absolutePath, new Supplier<FileSystemLocationSnapshot>(){

                @Override
                public FileSystemLocationSnapshot get() {
                    return DefaultFileSystemSnapshotter.this.snapshotAndCache(file, null);
                }
            });
        }
        return result;
    }

    private FileSystemLocationSnapshot snapshotAndCache(File file, @Nullable SnapshottingFilter filter) {
        InternableString absolutePath = new InternableString(file.getAbsolutePath());
        FileMetadataSnapshot metadata = this.statAndCache(absolutePath, file);
        return this.snapshotAndCache(absolutePath, file, metadata, filter);
    }

    private FileMetadataSnapshot statAndCache(InternableString absolutePath, File file) {
        FileMetadataSnapshot metadata = this.fileSystemMirror.getMetadata(absolutePath.asNonInterned());
        if (metadata == null) {
            metadata = this.stat.stat(file);
            this.fileSystemMirror.putMetadata(absolutePath.asInterned(), metadata);
        }
        return metadata;
    }

    private FileSystemLocationSnapshot snapshotAndCache(InternableString absolutePath, File file, FileMetadataSnapshot metadata, @Nullable SnapshottingFilter filter) {
        FileSystemLocationSnapshot fileSystemLocationSnapshot = this.fileSystemMirror.getSnapshot(absolutePath.asNonInterned());
        if (fileSystemLocationSnapshot == null) {
            AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
            fileSystemLocationSnapshot = this.snapshot(absolutePath.asInterned(), filter, file, metadata, hasBeenFiltered);
            if (!hasBeenFiltered.get()) {
                this.fileSystemMirror.putSnapshot(fileSystemLocationSnapshot);
            }
        }
        return fileSystemLocationSnapshot;
    }

    private FileSystemLocationSnapshot snapshot(String absolutePath, @Nullable SnapshottingFilter filter, File file, FileMetadataSnapshot metadata, AtomicBoolean hasBeenFiltered) {
        String internedName = (String)this.stringInterner.intern((Object)file.getName());
        switch (metadata.getType()) {
            case Missing: {
                return new MissingFileSnapshot(absolutePath, internedName);
            }
            case RegularFile: {
                return new RegularFileSnapshot(absolutePath, internedName, this.hasher.hash(file, metadata.getLength(), metadata.getLastModified()), FileMetadata.from(metadata));
            }
            case Directory: {
                SnapshottingFilter.DirectoryWalkerPredicate predicate = filter == null || filter.isEmpty() ? null : filter.getAsDirectoryWalkerPredicate();
                return this.directorySnapshotter.snapshot(absolutePath, predicate, hasBeenFiltered);
            }
        }
        throw new IllegalArgumentException("Unrecognized file type: " + metadata.getType());
    }

    @Override
    public FileSystemSnapshot snapshotDirectoryTree(final File root, final SnapshottingFilter filter) {
        final String path = root.getAbsolutePath();
        FileSystemLocationSnapshot snapshot = this.fileSystemMirror.getSnapshot(path);
        if (snapshot != null) {
            return this.filterSnapshot(snapshot, filter);
        }
        return this.producingSnapshots.guardByKey(path, new Supplier<FileSystemSnapshot>(){

            @Override
            public FileSystemSnapshot get() {
                FileSystemLocationSnapshot snapshot = DefaultFileSystemSnapshotter.this.fileSystemMirror.getSnapshot(path);
                if (snapshot == null) {
                    snapshot = DefaultFileSystemSnapshotter.this.snapshotAndCache(root, filter);
                    return snapshot.getType() != FileType.Directory ? DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, filter) : DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, SnapshottingFilter.EMPTY);
                }
                return DefaultFileSystemSnapshotter.this.filterSnapshot(snapshot, filter);
            }
        });
    }

    @Override
    public FileSystemSnapshotBuilder newFileSystemSnapshotBuilder() {
        return new FileSystemSnapshotBuilder(this.stringInterner, this.hasher);
    }

    private FileSystemSnapshot filterSnapshot(FileSystemLocationSnapshot snapshot, SnapshottingFilter filter) {
        if (snapshot.getType() == FileType.Missing) {
            return FileSystemSnapshot.EMPTY;
        }
        if (filter.isEmpty()) {
            return snapshot;
        }
        return FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot);
    }

    private static class StripedProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private class InternableString {
        private String string;
        private boolean interned;

        public InternableString(String nonInternedString) {
            this.string = nonInternedString;
        }

        public String asInterned() {
            if (!this.interned) {
                this.interned = true;
                this.string = (String)DefaultFileSystemSnapshotter.this.stringInterner.intern((Object)this.string);
            }
            return this.string;
        }

        public String asNonInterned() {
            return this.string;
        }
    }
}

