/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.TransformOutputs;

public interface TransformOutputsInternal
extends TransformOutputs {
    public static OutputLocationType determineOutputLocationType(File output, File inputArtifact, String inputArtifactPrefix, File outputDir, String outputDirPrefix) {
        if (output.equals(inputArtifact)) {
            return OutputLocationType.INPUT_ARTIFACT;
        }
        if (output.equals(outputDir)) {
            return OutputLocationType.WORKSPACE;
        }
        if (output.getPath().startsWith(outputDirPrefix)) {
            return OutputLocationType.WORKSPACE;
        }
        if (output.getPath().startsWith(inputArtifactPrefix)) {
            return OutputLocationType.INPUT_ARTIFACT;
        }
        throw new InvalidUserDataException("Transform output " + output.getPath() + " must be a part of the input artifact or refer to a relative path.");
    }

    public static void validateOutputExists(File output) {
        if (!output.exists()) {
            throw new InvalidUserDataException("Transform output " + output.getPath() + " must exist.");
        }
    }

    public ImmutableList<File> getRegisteredOutputs();

    public static enum OutputLocationType {
        INPUT_ARTIFACT,
        WORKSPACE;

    }
}

