/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.api.BuildCancelledException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;

public class CancelExecutionStep<C extends Context>
implements Step<C, Result> {
    private final BuildCancellationToken cancellationToken;
    private final Step<? super C, ? extends Result> delegate;

    public CancelExecutionStep(BuildCancellationToken cancellationToken, Step<? super C, ? extends Result> delegate) {
        this.cancellationToken = cancellationToken;
        this.delegate = delegate;
    }

    @Override
    public Result execute(C context) {
        Result result = this.delegate.execute(context);
        if (this.cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException("Build cancelled during executing " + context.getWork().getDisplayName());
        }
        return result;
    }
}

