/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b*\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u000b\u001a%\u0010\u0014\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u000b\u001a\u0014\u0010\"\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010'\u001a\u00020\u0001*\u00020\u000b\u001a\u0014\u0010(\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010)\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010*\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010+\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010,\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010-\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010.\u001a\u00020\u0001*\u00020\u000b\u001a\n\u0010/\u001a\u00020\u0001*\u00020\u000b\u001a\n\u00100\u001a\u00020\u0001*\u00020\u000b\u001a\n\u00101\u001a\u00020\u0001*\u00020\u000b\u001a\n\u00102\u001a\u00020\u0001*\u00020\u000b\u001a\n\u00103\u001a\u00020\u0001*\u00020\u000b\u001a\n\u00104\u001a\u00020\u0001*\u00020\u000b\u00a8\u00065"}, d2={"classFqNameEquals", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "isAny", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isArray", "isBoolean", "isBooleanArray", "isByte", "isByteArray", "isChar", "isCharArray", "isCharSequence", "isClassType", "hasQuestionMark", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/name/FqNameUnsafe;Ljava/lang/Boolean;)Z", "isCollection", "isComparable", "isDouble", "isDoubleArray", "isFloat", "isFloatArray", "isInt", "isIntArray", "isLong", "isLongArray", "isMarkedNullable", "isNotNullClassType", "isNothing", "isNullableAny", "isNullableArray", "isNullableBoolean", "isNullableChar", "isNullableClassType", "isNullableLong", "isNullablePrimitiveType", "isNullableString", "isNullableUnit", "isNumber", "isPrimitiveType", "isShort", "isShortArray", "isString", "isStringClassType", "isUnit", "isUnitOrNullableUnit", "ir.tree"})
public final class IrTypePredicatesKt {
    private static final boolean isNotNullClassType(@NotNull IrType $this$isNotNullClassType, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($this$isNotNullClassType, fqName2, false);
    }

    private static final boolean isNullableClassType(@NotNull IrType $this$isNullableClassType, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.isClassType($this$isNullableClassType, fqName2, true);
    }

    private static final boolean isClassType(@NotNull IrType $this$isClassType, FqNameUnsafe fqName2, Boolean hasQuestionMark) {
        if (!($this$isClassType instanceof IrSimpleType)) {
            return false;
        }
        if (hasQuestionMark != null && Intrinsics.areEqual((Object)((IrSimpleType)$this$isClassType).getHasQuestionMark(), (Object)hasQuestionMark) ^ true) {
            return false;
        }
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isClassType).getClassifier();
        if (!(irClassifierSymbol instanceof IrClassSymbol)) {
            irClassifierSymbol = null;
        }
        IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
        if (irClassSymbol == null) {
            return false;
        }
        IrClassSymbol classSymbol = irClassSymbol;
        return IrTypePredicatesKt.classFqNameEquals(classSymbol, fqName2);
    }

    static /* synthetic */ boolean isClassType$default(IrType irType, FqNameUnsafe fqNameUnsafe, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return IrTypePredicatesKt.isClassType(irType, fqNameUnsafe, bl);
    }

    private static final boolean classFqNameEquals(IrClassSymbol symbol2, FqNameUnsafe fqName2) {
        return symbol2.isBound() ? IrTypePredicatesKt.classFqNameEquals((IrClass)symbol2.getOwner(), fqName2) : IrTypePredicatesKt.classFqNameEquals((ClassDescriptor)symbol2.getDescriptor(), fqName2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean classFqNameEquals(IrClass declaration2, FqNameUnsafe fqName2) {
        if (!Intrinsics.areEqual((Object)declaration2.getName(), (Object)fqName2.shortName())) return false;
        FqName fqName3 = IrUtilsKt.getFqNameWhenAvailable(declaration2);
        if (!Intrinsics.areEqual((Object)fqName2, (Object)(fqName3 != null ? fqName3.toUnsafe() : null))) return false;
        return true;
    }

    private static final boolean classFqNameEquals(ClassDescriptor descriptor2, FqNameUnsafe fqName2) {
        return Intrinsics.areEqual((Object)descriptor2.getName(), (Object)fqName2.shortName()) && Intrinsics.areEqual((Object)fqName2, (Object)DescriptorUtils.getFqName(descriptor2));
    }

    public static final boolean isAny(@NotNull IrType $this$isAny) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAny, (String)"$this$isAny");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.any");
        return IrTypePredicatesKt.isNotNullClassType($this$isAny, fqNameUnsafe);
    }

    public static final boolean isNullableAny(@NotNull IrType $this$isNullableAny) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableAny, (String)"$this$isNullableAny");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.any");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableAny, fqNameUnsafe);
    }

    public static final boolean isString(@NotNull IrType $this$isString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isString, (String)"$this$isString");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.string");
        return IrTypePredicatesKt.isNotNullClassType($this$isString, fqNameUnsafe);
    }

    public static final boolean isNullableString(@NotNull IrType $this$isNullableString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableString, (String)"$this$isNullableString");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.string");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableString, fqNameUnsafe);
    }

    public static final boolean isStringClassType(@NotNull IrType $this$isStringClassType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isStringClassType, (String)"$this$isStringClassType");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.string");
        return IrTypePredicatesKt.isClassType$default($this$isStringClassType, fqNameUnsafe, null, 2, null);
    }

    public static final boolean isArray(@NotNull IrType $this$isArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isArray, (String)"$this$isArray");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.array;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.array");
        return IrTypePredicatesKt.isNotNullClassType($this$isArray, fqNameUnsafe);
    }

    public static final boolean isNullableArray(@NotNull IrType $this$isNullableArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableArray, (String)"$this$isNullableArray");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.array;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.array");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableArray, fqNameUnsafe);
    }

    public static final boolean isCollection(@NotNull IrType $this$isCollection) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCollection, (String)"$this$isCollection");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.collection.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.collection.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isCollection, fqNameUnsafe);
    }

    public static final boolean isNothing(@NotNull IrType $this$isNothing) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNothing, (String)"$this$isNothing");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.nothing;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.nothing");
        return IrTypePredicatesKt.isNotNullClassType($this$isNothing, fqNameUnsafe);
    }

    public static final boolean isPrimitiveType(@NotNull IrType $this$isPrimitiveType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isPrimitiveType, (String)"$this$isPrimitiveType");
            Iterable $this$any$iv = KotlinBuiltIns.FQ_NAMES.fqNameToPrimitiveType.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    FqNameUnsafe fqNameUnsafe = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"it");
                    if (!IrTypePredicatesKt.isNotNullClassType($this$isPrimitiveType, fqNameUnsafe)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isNullablePrimitiveType(@NotNull IrType $this$isNullablePrimitiveType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isNullablePrimitiveType, (String)"$this$isNullablePrimitiveType");
            Iterable $this$any$iv = KotlinBuiltIns.FQ_NAMES.fqNameToPrimitiveType.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FqNameUnsafe it = (FqNameUnsafe)element$iv;
                    boolean bl2 = false;
                    FqNameUnsafe fqNameUnsafe = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"it");
                    if (!IrTypePredicatesKt.isNullableClassType($this$isNullablePrimitiveType, fqNameUnsafe)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isMarkedNullable(@NotNull IrType $this$isMarkedNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMarkedNullable, (String)"$this$isMarkedNullable");
        IrType irType = $this$isMarkedNullable;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        return irSimpleType != null ? irSimpleType.getHasQuestionMark() : false;
    }

    public static final boolean isUnit(@NotNull IrType $this$isUnit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isUnit, (String)"$this$isUnit");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.unit;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.unit");
        return IrTypePredicatesKt.isNotNullClassType($this$isUnit, fqNameUnsafe);
    }

    public static final boolean isNullableUnit(@NotNull IrType $this$isNullableUnit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableUnit, (String)"$this$isNullableUnit");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.unit;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.unit");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableUnit, fqNameUnsafe);
    }

    public static final boolean isUnitOrNullableUnit(@NotNull IrType $this$isUnitOrNullableUnit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isUnitOrNullableUnit, (String)"$this$isUnitOrNullableUnit");
        return IrTypePredicatesKt.isUnit($this$isUnitOrNullableUnit) || IrTypePredicatesKt.isNullableUnit($this$isUnitOrNullableUnit);
    }

    public static final boolean isBoolean(@NotNull IrType $this$isBoolean) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isBoolean, (String)"$this$isBoolean");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._boolean;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._boolean");
        return IrTypePredicatesKt.isNotNullClassType($this$isBoolean, fqNameUnsafe);
    }

    public static final boolean isChar(@NotNull IrType $this$isChar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isChar, (String)"$this$isChar");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._char;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._char");
        return IrTypePredicatesKt.isNotNullClassType($this$isChar, fqNameUnsafe);
    }

    public static final boolean isByte(@NotNull IrType $this$isByte) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isByte, (String)"$this$isByte");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._byte;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._byte");
        return IrTypePredicatesKt.isNotNullClassType($this$isByte, fqNameUnsafe);
    }

    public static final boolean isShort(@NotNull IrType $this$isShort) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isShort, (String)"$this$isShort");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._short;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._short");
        return IrTypePredicatesKt.isNotNullClassType($this$isShort, fqNameUnsafe);
    }

    public static final boolean isInt(@NotNull IrType $this$isInt) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInt, (String)"$this$isInt");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._int;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._int");
        return IrTypePredicatesKt.isNotNullClassType($this$isInt, fqNameUnsafe);
    }

    public static final boolean isLong(@NotNull IrType $this$isLong) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isLong, (String)"$this$isLong");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._long;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._long");
        return IrTypePredicatesKt.isNotNullClassType($this$isLong, fqNameUnsafe);
    }

    public static final boolean isFloat(@NotNull IrType $this$isFloat) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFloat, (String)"$this$isFloat");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._float;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._float");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloat, fqNameUnsafe);
    }

    public static final boolean isDouble(@NotNull IrType $this$isDouble) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDouble, (String)"$this$isDouble");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._double;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._double");
        return IrTypePredicatesKt.isNotNullClassType($this$isDouble, fqNameUnsafe);
    }

    public static final boolean isNumber(@NotNull IrType $this$isNumber) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNumber, (String)"$this$isNumber");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.number");
        return IrTypePredicatesKt.isNotNullClassType($this$isNumber, fqNameUnsafe);
    }

    public static final boolean isComparable(@NotNull IrType $this$isComparable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isComparable, (String)"$this$isComparable");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.comparable.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.comparable.toUnsafe()");
        return IrTypePredicatesKt.isNotNullClassType($this$isComparable, fqNameUnsafe);
    }

    public static final boolean isCharSequence(@NotNull IrType $this$isCharSequence) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCharSequence, (String)"$this$isCharSequence");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.charSequence;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES.charSequence");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharSequence, fqNameUnsafe);
    }

    public static final boolean isBooleanArray(@NotNull IrType $this$isBooleanArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isBooleanArray, (String)"$this$isBooleanArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isBooleanArray, new FqNameUnsafe("kotlin.BooleanArray"));
    }

    public static final boolean isCharArray(@NotNull IrType $this$isCharArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCharArray, (String)"$this$isCharArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharArray, new FqNameUnsafe("kotlin.CharArray"));
    }

    public static final boolean isByteArray(@NotNull IrType $this$isByteArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isByteArray, (String)"$this$isByteArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isByteArray, new FqNameUnsafe("kotlin.ByteArray"));
    }

    public static final boolean isShortArray(@NotNull IrType $this$isShortArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isShortArray, (String)"$this$isShortArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isShortArray, new FqNameUnsafe("kotlin.ShortArray"));
    }

    public static final boolean isIntArray(@NotNull IrType $this$isIntArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isIntArray, (String)"$this$isIntArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isIntArray, new FqNameUnsafe("kotlin.IntArray"));
    }

    public static final boolean isLongArray(@NotNull IrType $this$isLongArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isLongArray, (String)"$this$isLongArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isLongArray, new FqNameUnsafe("kotlin.LongArray"));
    }

    public static final boolean isFloatArray(@NotNull IrType $this$isFloatArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFloatArray, (String)"$this$isFloatArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloatArray, new FqNameUnsafe("kotlin.FloatArray"));
    }

    public static final boolean isDoubleArray(@NotNull IrType $this$isDoubleArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDoubleArray, (String)"$this$isDoubleArray");
        return IrTypePredicatesKt.isNotNullClassType($this$isDoubleArray, new FqNameUnsafe("kotlin.DoubleArray"));
    }

    public static final boolean isNullableBoolean(@NotNull IrType $this$isNullableBoolean) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableBoolean, (String)"$this$isNullableBoolean");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._boolean;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._boolean");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableBoolean, fqNameUnsafe);
    }

    public static final boolean isNullableLong(@NotNull IrType $this$isNullableLong) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableLong, (String)"$this$isNullableLong");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._long;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._long");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableLong, fqNameUnsafe);
    }

    public static final boolean isNullableChar(@NotNull IrType $this$isNullableChar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableChar, (String)"$this$isNullableChar");
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES._char;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqNameUnsafe, (String)"KotlinBuiltIns.FQ_NAMES._char");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableChar, fqNameUnsafe);
    }
}

