/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.MoreObjects;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;

public class FunctionalExpressionKey {
    public static final int UNKNOWN_PARAM_COUNT = -1;
    private final int lambdaParameterCount;
    private final CoarseType lambdaReturnType;
    @NotNull
    private final String knownType;

    public FunctionalExpressionKey(int lambdaParameterCount, @NotNull CoarseType lambdaReturnType, @Nullable String knownFunExprType) {
        if (lambdaReturnType == null) {
            FunctionalExpressionKey.$$$reportNull$$$0(0);
        }
        this.lambdaParameterCount = lambdaParameterCount;
        this.lambdaReturnType = lambdaReturnType;
        this.knownType = StringUtil.notNullize(knownFunExprType);
    }

    @NotNull
    public static FunctionalExpressionKey deserializeKey(@NotNull DataInput dataStream) throws IOException {
        if (dataStream == null) {
            FunctionalExpressionKey.$$$reportNull$$$0(1);
        }
        byte parameterCount = dataStream.readByte();
        CoarseType type2 = CoarseType.values()[dataStream.readByte()];
        String knownType = IOUtil.readUTF(dataStream);
        FunctionalExpressionKey functionalExpressionKey = new FunctionalExpressionKey(parameterCount, type2, knownType);
        if (functionalExpressionKey == null) {
            FunctionalExpressionKey.$$$reportNull$$$0(2);
        }
        return functionalExpressionKey;
    }

    public void serializeKey(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            FunctionalExpressionKey.$$$reportNull$$$0(3);
        }
        dataStream.writeByte(this.lambdaParameterCount);
        dataStream.writeByte(this.lambdaReturnType.ordinal());
        IOUtil.writeUTF(dataStream, this.knownType);
    }

    public boolean canRepresent(int samParamCount, boolean booleanCompatible, boolean isVoid) {
        if (this.lambdaParameterCount >= 0 && samParamCount != this.lambdaParameterCount) {
            return false;
        }
        switch (this.lambdaReturnType) {
            case VOID: {
                return isVoid;
            }
            case NON_VOID: {
                return !isVoid;
            }
            case BOOLEAN: {
                return booleanCompatible;
            }
        }
        return true;
    }

    public static boolean isBooleanCompatible(PsiType samType) {
        return PsiType.BOOLEAN.equals(samType) || TypeConversionUtil.isAssignableFromPrimitiveWrapper(TypeConversionUtil.erasure(samType));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionalExpressionKey)) {
            return false;
        }
        FunctionalExpressionKey key = (FunctionalExpressionKey)o;
        if (this.lambdaParameterCount != key.lambdaParameterCount) {
            return false;
        }
        if (this.lambdaReturnType != key.lambdaReturnType) {
            return false;
        }
        return this.knownType.equals(key.knownType);
    }

    public int hashCode() {
        int result2 = this.lambdaParameterCount;
        result2 = 31 * result2 + this.lambdaReturnType.ordinal();
        result2 = 31 * result2 + this.knownType.hashCode();
        return result2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("lambdaParameterCount", this.lambdaParameterCount).add("type", (Object)this.lambdaReturnType).add("knownType", this.knownType).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaReturnType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/FunctionalExpressionKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/FunctionalExpressionKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKey";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serializeKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CoarseType {
        VOID,
        UNKNOWN,
        BOOLEAN,
        NON_VOID;

    }
}

