/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.file.FileCollection;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public interface UnitOfWork
extends CacheableEntity {
    public WorkResult execute(@Nullable InputChangesInternal var1);

    public Optional<Duration> getTimeout();

    public InputChangeTrackingStrategy getInputChangeTrackingStrategy();

    public void visitImplementations(ImplementationVisitor var1);

    public void visitInputProperties(InputPropertyVisitor var1);

    public void visitInputFileProperties(InputFilePropertyVisitor var1);

    public void visitOutputProperties(OutputPropertyVisitor var1);

    public void visitLocalState(LocalStateVisitor var1);

    public long markExecutionTime();

    public Optional<CachingDisabledReason> shouldDisableCaching();

    default public void markSnapshottingInputsFinished(CachingState cachingState) {
    }

    default public boolean isTaskHistoryMaintained() {
        return true;
    }

    public boolean isAllowedToLoadFromCache();

    public Optional<? extends Iterable<String>> getChangingOutputs();

    public boolean hasOverlappingOutputs();

    public boolean shouldCleanupOutputsOnNonIncrementalExecution();

    public ImmutableSortedMap<String, FileSystemSnapshot> getOutputFileSnapshotsBeforeExecution();

    public ExecutionHistoryStore getExecutionHistoryStore();

    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshotAfterOutputsGenerated();

    public static enum InputChangeTrackingStrategy {
        NONE(false),
        INCREMENTAL_PARAMETERS(true),
        ALL_PARAMETERS(true);

        private final boolean requiresInputChanges;

        private InputChangeTrackingStrategy(boolean requiresInputChanges) {
            this.requiresInputChanges = requiresInputChanges;
        }

        public boolean requiresInputChanges() {
            return this.requiresInputChanges;
        }
    }

    public static enum WorkResult {
        DID_WORK,
        DID_NO_WORK;

    }

    public static interface LocalStateVisitor {
        public void visitLocalStateRoot(File var1);
    }

    public static interface OutputPropertyVisitor {
        public void visitOutputProperty(String var1, TreeType var2, FileCollection var3);
    }

    public static interface InputFilePropertyVisitor {
        public void visitInputFileProperty(String var1, @Nullable Object var2, boolean var3, Supplier<CurrentFileCollectionFingerprint> var4);
    }

    public static interface InputPropertyVisitor {
        public void visitInputProperty(String var1, Object var2);
    }

    public static interface ImplementationVisitor {
        public void visitImplementation(Class<?> var1);

        public void visitImplementation(ImplementationSnapshot var1);

        public void visitAdditionalImplementation(ImplementationSnapshot var1);
    }
}

