/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.session;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.simpleframework.http.session.Controller;
import org.simpleframework.http.session.LeaseSession;
import org.simpleframework.http.session.Maintainer;
import org.simpleframework.http.session.Observer;
import org.simpleframework.http.session.Session;
import org.simpleframework.http.session.SessionException;
import org.simpleframework.util.lease.Cleaner;
import org.simpleframework.util.lease.Lease;
import org.simpleframework.util.lease.LeaseException;
import org.simpleframework.util.lease.LeaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Composer<T>
extends ConcurrentHashMap<T, Session>
implements Cleaner<T> {
    private LeaseManager<T> manager = new LeaseManager(this);
    private Controller<T> handler;
    private Observer<T> observer;
    private boolean closed;

    public Composer(Observer<T> observer, long duration, TimeUnit unit) {
        this.handler = new Maintainer<T>(this.manager, duration, unit);
        this.observer = observer;
    }

    public Session<T> lookup(T key) throws LeaseException {
        if (this.closed) {
            throw new SessionException("Session creation is closed", new Object[0]);
        }
        return this.locate(key);
    }

    private Session<T> locate(T key) throws LeaseException {
        Session session = (Session)this.get(key);
        if (session != null) {
            this.handler.renew(key);
        }
        return session;
    }

    public Session<T> compose(T key) throws LeaseException {
        if (this.closed) {
            throw new SessionException("Session creation is closed", new Object[0]);
        }
        return this.create(key);
    }

    private Session<T> create(T key) throws LeaseException {
        Lease<T> lease = this.handler.start(key);
        if (lease != null) {
            return this.create(key, lease);
        }
        return null;
    }

    private Session<T> create(T key, Lease<T> lease) throws LeaseException {
        LeaseSession<T> session = new LeaseSession<T>(lease);
        if (key != null) {
            this.put(key, session);
        }
        if (this.observer != null) {
            this.observer.create(session);
        }
        return session;
    }

    public void close() throws LeaseException {
        if (!this.closed) {
            this.manager.close();
        }
        this.closed = true;
    }

    @Override
    public void clean(T key) throws Exception {
        Session session = (Session)this.remove(key);
        if (key != null) {
            this.handler.cancel(key);
        }
        if (this.observer != null) {
            this.observer.cancel(session);
        }
    }
}

