/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.UnauthorizedFileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.specs.Spec;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Stat;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;

public class DefaultDirectoryWalker
implements DirectoryWalker {
    private final FileSystem fileSystem;

    public DefaultDirectoryWalker(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    static boolean shouldVisit(FileTreeElement element, Spec<? super FileTreeElement> spec) {
        return spec.isSatisfiedBy((Object)element);
    }

    @Override
    public void walkDir(File rootDir, RelativePath rootPath, org.gradle.api.file.FileVisitor visitor, Spec<? super FileTreeElement> spec, AtomicBoolean stopFlag, boolean postfix) {
        ArrayDeque<FileVisitDetails> directoryDetailsHolder = new ArrayDeque<FileVisitDetails>();
        try {
            PathVisitor pathVisitor = new PathVisitor(directoryDetailsHolder, spec, postfix, visitor, stopFlag, rootPath, this.fileSystem);
            Files.walkFileTree(rootDir.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, pathVisitor);
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not list contents of directory '%s'.", rootDir), (Throwable)e);
        }
    }

    private static class PathVisitor
    implements FileVisitor<Path> {
        private final Deque<FileVisitDetails> directoryDetailsHolder;
        private final Spec<? super FileTreeElement> spec;
        private final boolean postfix;
        private final org.gradle.api.file.FileVisitor visitor;
        private final AtomicBoolean stopFlag;
        private final RelativePath rootPath;
        private final FileSystem fileSystem;

        public PathVisitor(Deque<FileVisitDetails> directoryDetailsHolder, Spec<? super FileTreeElement> spec, boolean postfix, org.gradle.api.file.FileVisitor visitor, AtomicBoolean stopFlag, RelativePath rootPath, FileSystem fileSystem) {
            this.directoryDetailsHolder = directoryDetailsHolder;
            this.spec = spec;
            this.postfix = postfix;
            this.visitor = visitor;
            this.stopFlag = stopFlag;
            this.rootPath = rootPath;
            this.fileSystem = fileSystem;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            FileVisitDetails details = this.getFileVisitDetails(dir, attrs, true);
            if (this.directoryDetailsHolder.size() == 0 || DefaultDirectoryWalker.shouldVisit((FileTreeElement)details, this.spec)) {
                this.directoryDetailsHolder.push(details);
                if (this.directoryDetailsHolder.size() > 1 && !this.postfix) {
                    this.visitor.visitDir(details);
                }
                return this.checkStopFlag();
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        private FileVisitResult checkStopFlag() {
            return this.stopFlag.get() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            FileVisitDetails details = this.getFileVisitDetails(file, attrs, false);
            if (DefaultDirectoryWalker.shouldVisit((FileTreeElement)details, this.spec)) {
                if (attrs.isSymbolicLink()) {
                    throw new GradleException(String.format("Couldn't follow symbolic link '%s'.", file));
                }
                this.visitor.visitFile(details);
            }
            return this.checkStopFlag();
        }

        private FileVisitDetails getFileVisitDetails(Path file, @Nullable BasicFileAttributes attrs, boolean isDirectory) {
            RelativePath childPath;
            File child = file.toFile();
            FileVisitDetails dirDetails = this.directoryDetailsHolder.peek();
            RelativePath relativePath = dirDetails != null ? dirDetails.getRelativePath().append(!isDirectory, new String[]{child.getName()}) : (childPath = this.rootPath);
            if (attrs == null) {
                return new UnauthorizedFileVisitDetails(child, childPath);
            }
            return new DefaultFileVisitDetails(child, childPath, this.stopFlag, (Chmod)this.fileSystem, (Stat)this.fileSystem, isDirectory, attrs.lastModifiedTime().toMillis(), attrs.size());
        }

        private FileVisitDetails getUnauthorizedFileVisitDetails(Path file) {
            return this.getFileVisitDetails(file, null, false);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            FileVisitDetails details = this.getUnauthorizedFileVisitDetails(file);
            if (this.isNotFileSystemLoopException(exc) && DefaultDirectoryWalker.shouldVisit((FileTreeElement)details, this.spec)) {
                throw new GradleException(String.format("Could not read path '%s'.", file), (Throwable)exc);
            }
            return this.checkStopFlag();
        }

        private boolean isNotFileSystemLoopException(IOException e) {
            return e != null && !(e instanceof FileSystemLoopException);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (exc != null) {
                if (!(exc instanceof FileSystemLoopException)) {
                    throw new GradleException(String.format("Could not read directory path '%s'.", dir), (Throwable)exc);
                }
            } else if (this.postfix) {
                FileVisitDetails details = this.directoryDetailsHolder.peek();
                if (this.directoryDetailsHolder.size() > 1 && details != null) {
                    this.visitor.visitDir(details);
                }
            }
            this.directoryDetailsHolder.pop();
            return this.checkStopFlag();
        }
    }
}

