/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.IconPathPatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.ScalableIcon;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.ImageLoader;
import org.jetbrains.kotlin.com.intellij.util.Producer;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FixedHashMap;
import org.jetbrains.kotlin.com.intellij.util.ui.JBImageIcon;
import org.jetbrains.kotlin.com.intellij.util.ui.JBUI;
import org.jetbrains.kotlin.com.intellij.util.ui.UIUtil;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final ConcurrentMap<Pair<String, Object>, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = ContainerUtil.createWeakMap(200);
    private static volatile boolean STRICT_GLOBAL;
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    private static final AtomicReference<IconTransform> ourTransform;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    private static void updateTransform(Function<IconTransform, IconTransform> updater) {
        IconTransform next;
        IconTransform prev;
        while (!ourTransform.compareAndSet(prev = ourTransform.get(), next = updater.fun(prev))) {
        }
        if (prev != next) {
            ourIconsCache.clear();
            ourIcon2DisabledIcon.clear();
            ImageLoader.clearCache();
        }
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(0);
        }
        IconLoader.updateTransform(transform2 -> transform2.withPathPatcher(patcher));
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path2) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(4);
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path2;
        Icon icon = IconLoader.getIcon(path2, callerClass);
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path2, ClassLoader classLoader) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(6);
        }
        try {
            String pckg = path2.startsWith("AllIcons.") ? "org.jetbrains.kotlin.com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path2.substring(0, path2.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field2 = cur.getField(path2.substring(path2.lastIndexOf(46) + 1));
            return (Icon)field2.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull String path2, @NotNull Class aClass2) {
        Icon icon;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(9);
        }
        if (aClass2 == null) {
            IconLoader.$$$reportNull$$$0(10);
        }
        if ((icon = IconLoader.findIcon(path2, aClass2, aClass2.getClassLoader(), CachedImageIcon.HandleNotFound.strict(STRICT_LOCAL.get()), true)) == null) {
            LOG.error("Icon cannot be found in '" + path2 + "', aClass='" + aClass2 + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    private static boolean isReflectivePath(@NotNull String path2) {
        List<String> paths;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(22);
        }
        return (paths = StringUtil.split(path2, ".")).size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    private static Icon findIcon(@NotNull String originalPath, @Nullable Class clazz2, @NotNull ClassLoader classLoader, CachedImageIcon.HandleNotFound handleNotFound, boolean deferUrlResolve) {
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(23);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(24);
        }
        Pair<String, ClassLoader> patchedPath = ourTransform.get().patchPath(originalPath, classLoader);
        String path2 = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path2)) {
            return IconLoader.getReflectiveIcon(path2, classLoader);
        }
        Pair<String, ClassLoader> key = Pair.create(originalPath, classLoader);
        CachedImageIcon cachedIcon = (CachedImageIcon)ourIconsCache.get(key);
        if (cachedIcon == null) {
            cachedIcon = CachedImageIcon.create(originalPath, path2, classLoader, clazz2, handleNotFound, deferUrlResolve);
            if (cachedIcon == null) {
                return null;
            }
            cachedIcon = ConcurrencyUtil.cacheOrGet(ourIconsCache, key, cachedIcon);
        }
        return cachedIcon;
    }

    @Nullable
    private static ImageIcon checkIcon(@Nullable Image image, @NotNull CachedImageIcon cii) {
        if (cii == null) {
            IconLoader.$$$reportNull$$$0(29);
        }
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        JBImageIcon icon = new JBImageIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + cii);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(30);
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }

            @Override
            public Boolean get() {
                if (STRICT_GLOBAL) {
                    return true;
                }
                return (Boolean)super.get();
            }
        };
        ourTransform = new AtomicReference<IconTransform>(IconTransform.getDefault());
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cii";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransparentIcon";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installPathPatcher";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removePathPatcher";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReflectiveIcon";
                break;
            }
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findLafIcon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isReflectivePath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkIcon";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isGoodSize";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTransparentIcon";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIconSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IconTransform {
        private final boolean myDark;
        @NotNull
        private final IconPathPatcher[] myPatchers;
        @Nullable
        private final ImageFilter myFilter;

        private IconTransform(boolean dark, @NotNull IconPathPatcher[] patchers, @Nullable ImageFilter filter2) {
            if (patchers == null) {
                IconTransform.$$$reportNull$$$0(0);
            }
            this.myDark = dark;
            this.myPatchers = patchers;
            this.myFilter = filter2;
        }

        public boolean isDark() {
            return this.myDark;
        }

        @Nullable
        public ImageFilter getFilter() {
            return this.myFilter;
        }

        public IconTransform withPathPatcher(IconPathPatcher patcher) {
            return new IconTransform(this.myDark, ArrayUtil.append(this.myPatchers, patcher), this.myFilter);
        }

        public Pair<String, ClassLoader> patchPath(@NotNull String path2, ClassLoader classLoader) {
            if (path2 == null) {
                IconTransform.$$$reportNull$$$0(1);
            }
            for (IconPathPatcher patcher : this.myPatchers) {
                Class contextClass;
                String newPath = patcher.patchPath(path2, classLoader);
                if (newPath == null) {
                    newPath = patcher.patchPath(path2, null);
                }
                if (newPath == null) continue;
                LOG.info("replace '" + path2 + "' with '" + newPath + "'");
                ClassLoader contextClassLoader = patcher.getContextClassLoader(path2, classLoader);
                if (contextClassLoader == null && (contextClass = patcher.getContextClass(path2)) != null) {
                    contextClassLoader = contextClass.getClassLoader();
                }
                return Pair.create(newPath, contextClassLoader);
            }
            return Pair.create(path2, null);
        }

        public static IconTransform getDefault() {
            return new IconTransform(UIUtil.isUnderDarcula(), new IconPathPatcher[0], null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$IconTransform";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patchPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class CachedImageIcon
    extends JBUI.RasterJBIcon
    implements ScalableIcon {
        private final Object myLock;
        @Nullable
        private volatile Object myRealIcon;
        @Nullable
        private final String myOriginalPath;
        @NotNull
        private volatile MyUrlResolver myResolver;
        @Nullable(value="when not overridden")
        private final Boolean myDarkOverridden;
        @NotNull
        private volatile IconTransform myTransform;
        private final boolean myUseCacheOnLoad;
        @Nullable
        private final Producer<RGBImageFilter> myLocalFilterSupplier;
        private final MyScaledIconsCache myScaledIconsCache;

        private CachedImageIcon(@NotNull MyUrlResolver urlResolver, @Nullable String originalPath, boolean useCacheOnLoad) {
            if (urlResolver == null) {
                CachedImageIcon.$$$reportNull$$$0(1);
            }
            this(originalPath, urlResolver, null, useCacheOnLoad, (IconTransform)ourTransform.get(), null);
        }

        private CachedImageIcon(@Nullable String originalPath, @NotNull MyUrlResolver resolver2, @Nullable Boolean darkOverridden, boolean useCacheOnLoad, @NotNull IconTransform transform2, @Nullable Producer<RGBImageFilter> localFilterSupplier) {
            if (resolver2 == null) {
                CachedImageIcon.$$$reportNull$$$0(2);
            }
            if (transform2 == null) {
                CachedImageIcon.$$$reportNull$$$0(3);
            }
            this.myLock = new Object();
            this.myScaledIconsCache = new MyScaledIconsCache();
            this.myOriginalPath = originalPath;
            this.myResolver = resolver2;
            this.myDarkOverridden = darkOverridden;
            this.myUseCacheOnLoad = useCacheOnLoad;
            this.myTransform = transform2;
            this.myLocalFilterSupplier = localFilterSupplier;
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new JBUI.BaseScaleContext.UpdateListener(){

                @Override
                public void contextUpdated() {
                    myRealIcon = null;
                }
            });
        }

        @Contract(value="_, _, _, _, _, true -> !null")
        static CachedImageIcon create(@NotNull String originalPath, @Nullable String pathToResolve, @NotNull ClassLoader classLoader, @Nullable Class clazz2, HandleNotFound handleNotFound, boolean deferUrlResolve) {
            if (originalPath == null) {
                CachedImageIcon.$$$reportNull$$$0(4);
            }
            if (classLoader == null) {
                CachedImageIcon.$$$reportNull$$$0(5);
            }
            MyUrlResolver resolver2 = new MyUrlResolver(pathToResolve == null ? originalPath : pathToResolve, clazz2, classLoader, handleNotFound);
            CachedImageIcon icon = new CachedImageIcon(resolver2, originalPath, true);
            if (!deferUrlResolve && icon.getURL() == null) {
                return null;
            }
            return icon;
        }

        @NotNull
        private ImageIcon getRealIcon() {
            ImageIcon imageIcon = this.getRealIcon(null);
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(6);
            }
            return imageIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private ImageIcon getRealIcon(@Nullable JBUI.ScaleContext ctx2) {
            if (!this.isValid()) {
                if (IconLoader.isLoaderDisabled()) {
                    ImageIcon imageIcon = EMPTY_ICON;
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(7);
                    }
                    return imageIcon;
                }
                Object object = this.myLock;
                synchronized (object) {
                    if (!this.isValid()) {
                        this.myTransform = (IconTransform)ourTransform.get();
                        this.myResolver.resolve();
                        this.myRealIcon = null;
                        this.myScaledIconsCache.clear();
                        if (this.myOriginalPath != null) {
                            this.myResolver = this.myResolver.patch(this.myOriginalPath, this.myTransform);
                        }
                    }
                }
            }
            Object realIcon = this.myRealIcon;
            Object object = this.myLock;
            synchronized (object) {
                ImageIcon icon;
                if (!this.updateScaleContext(ctx2) && realIcon != null && (icon = CachedImageIcon.unwrapIcon(realIcon)) != null) {
                    ImageIcon imageIcon = icon;
                    // MONITOREXIT @DISABLED, blocks:[5, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(8);
                    }
                    return imageIcon;
                }
                icon = this.myScaledIconsCache.getOrScaleIcon(1.0f);
                if (icon != null) {
                    this.myRealIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                    ImageIcon imageIcon = icon;
                    // MONITOREXIT @DISABLED, blocks:[5, 8] lbl31 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(9);
                    }
                    return imageIcon;
                }
            }
            ImageIcon imageIcon = EMPTY_ICON;
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(10);
            }
            return imageIcon;
        }

        @Nullable
        private static ImageIcon unwrapIcon(Object realIcon) {
            Object icon = realIcon;
            if (icon instanceof Reference) {
                icon = ((Reference)icon).get();
            }
            return icon instanceof ImageIcon ? (ImageIcon)icon : null;
        }

        private boolean isValid() {
            return this.myTransform == ourTransform.get() && this.myResolver.isResolved();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            this.getRealIcon(JBUI.ScaleContext.create(c, g2d)).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            URL url;
            if (this.myResolver.isResolved() && (url = this.myResolver.getURL()) != null) {
                return url.toString();
            }
            return this.myOriginalPath != null ? this.myOriginalPath : "unknown path";
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                CachedImageIcon cachedImageIcon = this;
                if (cachedImageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(11);
                }
                return cachedImageIcon;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(scale);
            if (icon != null) {
                ImageIcon imageIcon = icon;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(12);
                }
                return imageIcon;
            }
            CachedImageIcon cachedImageIcon = this;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(13);
            }
            return cachedImageIcon;
        }

        private boolean isDark() {
            return this.myDarkOverridden == null ? this.myTransform.isDark() : this.myDarkOverridden.booleanValue();
        }

        @Nullable
        private ImageFilter[] getFilters() {
            ImageFilter local2;
            ImageFilter global = this.myTransform.getFilter();
            ImageFilter imageFilter = local2 = this.myLocalFilterSupplier != null ? (ImageFilter)this.myLocalFilterSupplier.produce() : null;
            if (global != null && local2 != null) {
                return new ImageFilter[]{global, local2};
            }
            if (global != null) {
                return new ImageFilter[]{global};
            }
            if (local2 != null) {
                return new ImageFilter[]{local2};
            }
            return null;
        }

        @Nullable
        public URL getURL() {
            return this.myResolver.getURL();
        }

        @Nullable
        private Image loadFromUrl(@NotNull JBUI.ScaleContext ctx2, boolean dark) {
            URL url;
            if (ctx2 == null) {
                CachedImageIcon.$$$reportNull$$$0(17);
            }
            if ((url = this.getURL()) == null) {
                return null;
            }
            return ImageLoader.loadFromUrl(url, true, this.myUseCacheOnLoad, dark, this.getFilters(), ctx2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urlResolver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolver";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterSupplier";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRealIcon";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWithFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithFilter";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "loadFromUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyUrlResolver {
            @Nullable
            private final Class myClass;
            @Nullable
            private final ClassLoader myClassLoader;
            @Nullable
            private final String myOverriddenPath;
            @NotNull
            private final HandleNotFound myHandleNotFound;
            @Nullable
            private URL myUrl;
            private volatile boolean isResolved;

            MyUrlResolver(@NotNull String path2, @Nullable Class clazz2, @Nullable ClassLoader classLoader, @NotNull HandleNotFound handleNotFound) {
                if (path2 == null) {
                    MyUrlResolver.$$$reportNull$$$0(0);
                }
                if (handleNotFound == null) {
                    MyUrlResolver.$$$reportNull$$$0(1);
                }
                this.myOverriddenPath = path2;
                this.myClass = clazz2;
                this.myClassLoader = classLoader;
                this.myHandleNotFound = handleNotFound;
                if (!Registry.is("ide.icons.deferUrlResolve")) {
                    this.resolve();
                }
            }

            boolean isResolved() {
                return this.isResolved;
            }

            MyUrlResolver resolve() throws RuntimeException {
                if (this.isResolved) {
                    return this;
                }
                try {
                    URL url = null;
                    String path2 = this.myOverriddenPath;
                    if (path2 != null) {
                        if (this.myClassLoader != null) {
                            path2 = StringUtil.trimStart(path2, "/");
                            url = MyUrlResolver.findURL(path2, this.myClassLoader::getResource);
                        }
                        if (url == null && this.myClass != null) {
                            url = MyUrlResolver.findURL(path2, this.myClass::getResource);
                        }
                    }
                    if (url == null) {
                        this.myHandleNotFound.handle("Can't find icon in '" + path2 + "' near " + this.myClassLoader);
                    }
                    this.myUrl = url;
                }
                finally {
                    this.isResolved = true;
                }
                return this;
            }

            @Nullable
            URL getURL() {
                if (!this.isResolved()) {
                    return this.resolve().myUrl;
                }
                return this.myUrl;
            }

            MyUrlResolver patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
                if (originalPath == null) {
                    MyUrlResolver.$$$reportNull$$$0(2);
                }
                if (transform2 == null) {
                    MyUrlResolver.$$$reportNull$$$0(3);
                }
                Pair<String, ClassLoader> patchedPath = transform2.patchPath(originalPath, this.myClassLoader);
                ClassLoader classLoader = patchedPath.second != null ? (ClassLoader)patchedPath.second : this.myClassLoader;
                String path2 = (String)patchedPath.first;
                if (classLoader != null && path2 != null && path2.startsWith("/")) {
                    return new MyUrlResolver(path2.substring(1), null, classLoader, this.myHandleNotFound).resolve();
                }
                return this;
            }

            @Nullable
            private static URL findURL(@NotNull String path2, @NotNull Function<String, URL> urlProvider) {
                URL url;
                if (path2 == null) {
                    MyUrlResolver.$$$reportNull$$$0(4);
                }
                if (urlProvider == null) {
                    MyUrlResolver.$$$reportNull$$$0(5);
                }
                if ((url = urlProvider.fun(path2)) != null) {
                    return url;
                }
                if (path2.endsWith(".png")) {
                    path2 = path2.substring(0, path2.length() - 4) + ".svg";
                } else if (path2.endsWith(".svg")) {
                    path2 = path2.substring(0, path2.length() - 4) + ".png";
                } else {
                    LOG.debug("unexpected path: ", path2);
                }
                return urlProvider.fun(path2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handleNotFound";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "originalPath";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "transform";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "urlProvider";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon$MyUrlResolver";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "patch";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findURL";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static enum HandleNotFound {
            THROW_EXCEPTION{

                @Override
                void handle(String msg) {
                    throw new RuntimeException(msg);
                }
            }
            ,
            LOG_ERROR{

                @Override
                void handle(String msg) {
                    LOG.error(msg);
                }
            }
            ,
            IGNORE;


            void handle(String msg) throws RuntimeException {
            }

            static HandleNotFound strict(boolean strict) {
                return strict ? THROW_EXCEPTION : IGNORE;
            }
        }

        private class MyScaledIconsCache {
            private final Map<Couple<Double>, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new FixedHashMap(5));

            private MyScaledIconsCache() {
            }

            private Couple<Double> key(@NotNull JBUI.ScaleContext ctx2) {
                if (ctx2 == null) {
                    MyScaledIconsCache.$$$reportNull$$$0(0);
                }
                return new Couple<Double>(ctx2.getScale(JBUI.ScaleType.USR_SCALE) * ctx2.getScale(JBUI.ScaleType.OBJ_SCALE), ctx2.getScale(JBUI.ScaleType.SYS_SCALE));
            }

            ImageIcon getOrScaleIcon(float scale) {
                ImageIcon icon;
                JBUI.ScaleContext ctx2 = (JBUI.ScaleContext)CachedImageIcon.this.getScaleContext();
                if (scale != 1.0f) {
                    ctx2 = (JBUI.ScaleContext)ctx2.copy();
                    ctx2.update(JBUI.ScaleType.OBJ_SCALE.of(scale));
                }
                if ((icon = (ImageIcon)SoftReference.dereference(this.scaledIconsCache.get(this.key(ctx2)))) != null) {
                    return icon;
                }
                Image image = CachedImageIcon.this.loadFromUrl(ctx2, CachedImageIcon.this.isDark());
                icon = IconLoader.checkIcon(image, CachedImageIcon.this);
                if (icon != null && 4L * (long)icon.getIconWidth() * (long)icon.getIconHeight() < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(this.key(ctx2), new SoftReference<ImageIcon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ctx", "org/jetbrains/kotlin/com/intellij/openapi/util/IconLoader$CachedImageIcon$MyScaledIconsCache", "key"));
            }
        }
    }
}

