/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaConventionalSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.ResourceChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.FileUtils;

class InputChangeAction
implements Action<InputFileDetails> {
    private final RecompilationSpec spec;
    private final SourceFileChangeProcessor javaChangeProcessor;
    private final AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor;
    private final ResourceChangeProcessor resourceChangeProcessor;
    private final JavaConventionalSourceFileClassNameConverter sourceFileClassNameConverter;

    InputChangeAction(RecompilationSpec spec, SourceFileChangeProcessor javaChangeProcessor, AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor, ResourceChangeProcessor resourceChangeProcessor, JavaConventionalSourceFileClassNameConverter sourceFileClassNameConverter) {
        this.spec = spec;
        this.javaChangeProcessor = javaChangeProcessor;
        this.annotationProcessorChangeProcessor = annotationProcessorChangeProcessor;
        this.resourceChangeProcessor = resourceChangeProcessor;
        this.sourceFileClassNameConverter = sourceFileClassNameConverter;
    }

    public void execute(InputFileDetails input) {
        if (this.spec.getFullRebuildCause() != null) {
            return;
        }
        File file = input.getFile();
        if (FileUtils.hasExtension((File)file, (String)".java")) {
            Collection<String> classNames = this.sourceFileClassNameConverter.getClassNames(file);
            if (classNames.isEmpty()) {
                this.spec.setFullRebuildCause("source dirs are changed", file);
            } else {
                this.javaChangeProcessor.processChange(file, classNames, this.spec);
            }
        } else if (FileUtils.hasExtension((File)file, (String)".jar") || FileUtils.hasExtension((File)file, (String)".class")) {
            this.annotationProcessorChangeProcessor.processChange(input, this.spec);
        } else {
            this.resourceChangeProcessor.processChange(input, this.spec);
        }
    }
}

