/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.transport;

import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.http.conn.HttpHostConnectException;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;

public class NetworkingIssueVerifier {
    public static <E extends Throwable> boolean isLikelyTransientNetworkingIssue(E failure) {
        if (failure instanceof SocketTimeoutException || failure instanceof HttpHostConnectException) {
            return true;
        }
        if (failure instanceof DefaultMultiCauseException) {
            List causes = ((DefaultMultiCauseException)failure).getCauses();
            for (Throwable cause : causes) {
                if (!NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(cause)) continue;
                return true;
            }
        }
        if (failure instanceof HttpErrorStatusCodeException) {
            HttpErrorStatusCodeException httpError = (HttpErrorStatusCodeException)failure;
            return httpError.isServerError() || NetworkingIssueVerifier.isTransientClientError(httpError.getStatusCode());
        }
        Throwable cause = failure.getCause();
        if (cause != null && cause != failure) {
            return NetworkingIssueVerifier.isLikelyTransientNetworkingIssue(cause);
        }
        return false;
    }

    private static boolean isTransientClientError(int statusCode) {
        return statusCode == 408 || statusCode == 429;
    }
}

