/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.util.DeprecationLogger;

public abstract class AbstractProperty<T>
extends AbstractMinimalProvider<T>
implements PropertyInternal<T> {
    private State state = State.ImplicitValue;
    private boolean finalizeOnNextGet;
    private boolean disallowChanges;
    private Task producer;

    @Override
    public void attachProducer(Task task) {
        if (this.producer != null && this.producer != task) {
            throw new IllegalStateException("This property already has a producer task associated with it.");
        }
        this.producer = task;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (this.producer != null) {
            context.add(this.producer);
            return true;
        }
        return false;
    }

    public void finalizeValue() {
        if (this.state != State.Final) {
            this.makeFinal();
        }
        this.state = State.Final;
        this.disallowChanges = true;
    }

    public void disallowChanges() {
        this.disallowChanges = true;
    }

    @Override
    public void implicitFinalizeValue() {
        this.finalizeOnNextGet = true;
    }

    protected abstract void applyDefaultValue();

    protected abstract void makeFinal();

    protected void beforeRead() {
        if (this.state == State.Final) {
            return;
        }
        if (this.finalizeOnNextGet) {
            this.makeFinal();
            this.state = State.Final;
        }
    }

    protected boolean beforeMutate() {
        if (this.canMutate()) {
            if (this.state == State.ImplicitValue) {
                this.applyDefaultValue();
                this.state = State.ExplicitValue;
            }
            return true;
        }
        return false;
    }

    protected boolean beforeReset() {
        if (this.canMutate()) {
            this.state = State.ImplicitValue;
            return true;
        }
        return false;
    }

    protected boolean shouldApplyConvention() {
        if (this.canMutate()) {
            return this.state == State.ImplicitValue;
        }
        return false;
    }

    private boolean canMutate() {
        if (this.state == State.Final && this.disallowChanges) {
            throw new IllegalStateException("The value for this property is final and cannot be changed any further.");
        }
        if (this.disallowChanges) {
            throw new IllegalStateException("The value for this property cannot be changed any further.");
        }
        if (this.state == State.Final) {
            DeprecationLogger.nagUserOfDiscontinuedInvocation((String)"Changing the value for a property with a final value");
            return false;
        }
        return true;
    }

    private static enum State {
        ImplicitValue,
        ExplicitValue,
        Final;

    }
}

