/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.simpleframework.transport.Flusher;
import org.simpleframework.transport.Scheduler;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.Writer;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;

class SocketFlusher
implements Flusher {
    private Signaller signaller;
    private Scheduler scheduler;
    private Writer writer;
    private boolean closed;

    public SocketFlusher(Reactor reactor, Writer writer) throws IOException {
        this.signaller = new Signaller(writer);
        this.scheduler = new Scheduler(reactor, this.signaller, this);
        this.writer = writer;
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new TransportException("Flusher is closed");
        }
        boolean block = this.writer.isBlocking();
        if (!this.closed) {
            this.scheduler.schedule(block);
        }
    }

    private synchronized void execute() throws IOException {
        boolean ready = this.writer.flush();
        if (!ready) {
            boolean block = this.writer.isBlocking();
            if (!block && !this.closed) {
                this.scheduler.release();
            }
            this.scheduler.repeat();
        } else {
            this.scheduler.ready();
        }
    }

    private synchronized void abort() throws IOException {
        this.scheduler.close();
        this.writer.close();
    }

    public synchronized void close() throws IOException {
        boolean ready = this.writer.flush();
        if (!this.closed) {
            this.closed = true;
        }
        if (!ready) {
            this.scheduler.schedule(true);
        }
    }

    private class Signaller
    implements Operation {
        private final Writer writer;

        public Signaller(Writer writer) {
            this.writer = writer;
        }

        public SocketChannel getChannel() {
            return this.writer.getChannel();
        }

        public void run() {
            try {
                SocketFlusher.this.execute();
            }
            catch (Exception e) {
                this.cancel();
            }
        }

        public void cancel() {
            try {
                SocketFlusher.this.abort();
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

