/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.groovy;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.model.io.ModelReader;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.maven.polyglot.PolyglotModelUtil;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.groovy.builder.ModelBuilder;
import org.sonatype.maven.polyglot.io.ModelReaderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ModelReader.class, hint="groovy")
public class GroovyModelReader
extends ModelReaderSupport {
    @Requirement
    protected Logger log;
    @Requirement
    private ModelBuilder builder;
    @Requirement
    private ExecuteManager executeManager;

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model model;
        assert (input != null);
        try {
            model = this.doRead(input, options);
        }
        catch (Throwable t) {
            t = StackTraceUtils.sanitize((Throwable)t);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        this.executeManager.install(model);
        if (this.log.isDebugEnabled()) {
            DefaultModelWriter writer = new DefaultModelWriter();
            StringWriter buff = new StringWriter();
            writer.write((Writer)buff, null, model);
            this.log.debug("Read groovy model: \n" + buff);
        }
        return model;
    }

    private Model doRead(Reader input, Map<String, ?> options) throws IOException {
        assert (input != null);
        GroovyShell shell = new GroovyShell();
        String text = IOUtil.toString((Reader)input);
        String location = PolyglotModelUtil.getLocation(options);
        Script script = shell.parse(new GroovyCodeSource(text, location, location));
        assert (this.builder != null);
        return (Model)this.builder.build(script);
    }
}

