/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkOperationBackOffAndRetry;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.xml.XmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMavenPublisher
implements MavenPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenPublisher.class);
    private static final Set<String> JAR_PACKAGINGS = ImmutableSet.of((Object)"jar", (Object)"ejb", (Object)"bundle", (Object)"maven-plugin", (Object)"eclipse-plugin");
    private static final String POM_FILE_ENCODING = "UTF-8";
    private final Factory<File> temporaryDirFactory;
    private final XmlTransformer xmlTransformer = new XmlTransformer();

    AbstractMavenPublisher(Factory<File> temporaryDirFactory) {
        this.temporaryDirFactory = temporaryDirFactory;
    }

    protected void publish(MavenNormalizedPublication publication, ExternalResourceRepository repository, URI rootUri, boolean localRepo) {
        String groupId = publication.getGroupId();
        String artifactId = publication.getArtifactId();
        String version = publication.getVersion();
        ModuleArtifactPublisher artifactPublisher = new ModuleArtifactPublisher(repository, localRepo, rootUri, groupId, artifactId, version);
        if (ArtifactUtils.isSnapshot((String)version)) {
            ExternalResourceName snapshotMetadataPath = artifactPublisher.getSnapshotMetadataLocation();
            Metadata snapshotMetadata = this.createSnapshotMetadata(publication, groupId, artifactId, version, repository, snapshotMetadataPath);
            artifactPublisher.publish(snapshotMetadataPath, this.writeMetadataToTmpFile(snapshotMetadata, "snapshot-maven-metadata.xml"));
            if (!localRepo) {
                artifactPublisher.artifactVersion = ((SnapshotVersion)snapshotMetadata.getVersioning().getSnapshotVersions().get(0)).getVersion();
            }
        }
        if (publication.getMainArtifact() != null) {
            String packaging = publication.getPackaging();
            String extension = packaging == null || JAR_PACKAGINGS.contains(packaging) ? publication.getMainArtifact().getExtension() : packaging;
            artifactPublisher.publish(null, extension, publication.getMainArtifact().getFile());
        }
        artifactPublisher.publish(null, "pom", publication.getPomArtifact().getFile());
        for (MavenArtifact artifact : publication.getAdditionalArtifacts()) {
            artifactPublisher.publish(artifact.getClassifier(), artifact.getExtension(), artifact.getFile());
        }
        ExternalResourceName externalResource = artifactPublisher.getMetadataLocation();
        Metadata metadata = this.createMetadata(groupId, artifactId, version, repository, externalResource);
        artifactPublisher.publish(externalResource, this.writeMetadataToTmpFile(metadata, "module-maven-metadata.xml"));
    }

    private Metadata createMetadata(String groupId, String artifactId, String version, ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Versioning versioning = this.getExistingVersioning(repository, metadataResource);
        if (!versioning.getVersions().contains(version)) {
            versioning.addVersion(version);
        }
        versioning.setLatest(version);
        if (!ArtifactUtils.isSnapshot((String)version)) {
            versioning.setRelease(version);
        }
        versioning.updateTimestamp();
        Metadata metadata = new Metadata();
        metadata.setGroupId(groupId);
        metadata.setArtifactId(artifactId);
        metadata.setVersioning(versioning);
        return metadata;
    }

    private Versioning getExistingVersioning(ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        Metadata recessive;
        ExternalResourceReadResult<Metadata> existing = this.readExistingMetadata(repository, metadataResource);
        if (existing != null && (recessive = (Metadata)existing.getResult()).getVersioning() != null) {
            return recessive.getVersioning();
        }
        return new Versioning();
    }

    private File writeMetadataToTmpFile(Metadata metadata, String fileName) {
        File metadataFile = new File((File)this.temporaryDirFactory.create(), fileName);
        this.xmlTransformer.transform(metadataFile, POM_FILE_ENCODING, writer -> {
            try {
                new MetadataXpp3Writer().write(writer, metadata);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        });
        return metadataFile;
    }

    ExternalResourceReadResult<Metadata> readExistingMetadata(ExternalResourceRepository repository, ExternalResourceName metadataResource) {
        return repository.resource(metadataResource).withContentIfPresent(inputStream -> {
            try {
                return new MetadataXpp3Reader().read(inputStream, false);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        });
    }

    protected abstract Metadata createSnapshotMetadata(MavenNormalizedPublication var1, String var2, String var3, String var4, ExternalResourceRepository var5, ExternalResourceName var6);

    private static class ModuleArtifactPublisher {
        private final NetworkOperationBackOffAndRetry networkOperationRunner = new NetworkOperationBackOffAndRetry();
        private final ExternalResourceRepository repository;
        private final boolean localRepo;
        private final URI rootUri;
        private final String groupPath;
        private final String artifactId;
        private final String moduleVersion;
        private String artifactVersion;

        ModuleArtifactPublisher(ExternalResourceRepository repository, boolean localRepo, URI rootUri, String groupId, String artifactId, String moduleVersion) {
            this.repository = repository.withProgressLogging();
            this.localRepo = localRepo;
            this.rootUri = rootUri;
            this.groupPath = groupId.replace('.', '/');
            this.artifactId = artifactId;
            this.moduleVersion = moduleVersion;
            this.artifactVersion = moduleVersion;
        }

        ExternalResourceName getMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        ExternalResourceName getSnapshotMetadataLocation() {
            String path = this.groupPath + '/' + this.artifactId + '/' + this.moduleVersion + '/' + this.getMetadataFileName();
            return new ExternalResourceName(this.rootUri, path);
        }

        private String getMetadataFileName() {
            if (this.localRepo) {
                return "maven-metadata-local.xml";
            }
            return "maven-metadata.xml";
        }

        void publish(String classifier, String extension, File content) {
            StringBuilder path = new StringBuilder(128);
            path.append(this.groupPath).append('/');
            path.append(this.artifactId).append('/');
            path.append(this.moduleVersion).append('/');
            path.append(this.artifactId).append('-').append(this.artifactVersion);
            if (classifier != null) {
                path.append('-').append(classifier);
            }
            if (extension.length() > 0) {
                path.append('.').append(extension);
            }
            ExternalResourceName externalResource = new ExternalResourceName(this.rootUri, path.toString());
            this.publish(externalResource, content);
        }

        void publish(ExternalResourceName externalResource, File content) {
            if (!this.localRepo) {
                LOGGER.info("Uploading {} to {}", (Object)externalResource.getShortDisplayName(), (Object)externalResource.getPath());
            }
            this.putResource(externalResource, (ReadableContent)new FileReadableContent(content));
            if (!this.localRepo) {
                this.publishChecksums(externalResource, content);
            }
        }

        private void publishChecksums(ExternalResourceName destination, File content) {
            byte[] sha1 = this.createChecksumFile(content, "SHA1", 40);
            this.putResource(destination.append(".sha1"), (ReadableContent)new ByteArrayReadableContent(sha1));
            byte[] md5 = this.createChecksumFile(content, "MD5", 32);
            this.putResource(destination.append(".md5"), (ReadableContent)new ByteArrayReadableContent(md5));
        }

        private byte[] createChecksumFile(File src, String algorithm, int checksumLength) {
            HashValue hash = HashUtil.createHash((File)src, (String)algorithm);
            String formattedHashString = hash.asZeroPaddedHexString(checksumLength);
            return formattedHashString.getBytes(StandardCharsets.US_ASCII);
        }

        private void putResource(final ExternalResourceName externalResource, final ReadableContent readableContent) {
            this.networkOperationRunner.withBackoffAndRetry(new Runnable(){

                @Override
                public void run() {
                    repository.resource(externalResource).put(readableContent);
                }

                public String toString() {
                    return "PUT " + externalResource.getDisplayName();
                }
            });
        }
    }
}

