/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DefaultPendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DeselectVersionAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PendingDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ReplaceSelectionWithConflictResultAction;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveOptimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.SelectorStateResolver;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.ComponentResolveResult;

class ResolveState
implements ComponentStateFactory<ComponentState> {
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final Map<ModuleIdentifier, ModuleResolveState> modules;
    private final Map<ResolvedConfigurationIdentifier, NodeState> nodes;
    private final Map<ComponentSelector, SelectorState> selectors;
    private final RootNode root;
    private final IdGenerator<Long> idGenerator;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final Deque<NodeState> queue;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final DeselectVersionAction deselectVersionAction = new DeselectVersionAction(this);
    private final ReplaceSelectionWithConflictResultAction replaceSelectionWithConflictResultAction;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final ImmutableAttributesFactory attributesFactory;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final VersionSelectorScheme versionSelectorScheme;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    private final SelectorStateResolver<ComponentState> selectorStateResolver;
    private final ResolveOptimizations resolveOptimizations;
    private final Map<VersionConstraint, ResolvedVersionConstraint> resolvedVersionConstraints = Maps.newHashMap();
    private final AttributeDesugaring attributeDesugaring;

    public ResolveState(IdGenerator<Long> idGenerator, ComponentResolveResult rootResult, String rootConfigurationName, DependencyToComponentIdResolver idResolver, ComponentMetaDataResolver metaDataResolver, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, ComponentSelectorConverter componentSelectorConverter, ImmutableAttributesFactory attributesFactory, DependencySubstitutionApplicator dependencySubstitutionApplicator, VersionSelectorScheme versionSelectorScheme, Comparator<Version> versionComparator, VersionParser versionParser, ModuleConflictResolver conflictResolver, int graphSize) {
        this.idGenerator = idGenerator;
        this.idResolver = idResolver;
        this.metaDataResolver = metaDataResolver;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.modules = new LinkedHashMap<ModuleIdentifier, ModuleResolveState>(graphSize);
        this.nodes = new LinkedHashMap<ResolvedConfigurationIdentifier, NodeState>(3 * graphSize / 2);
        this.selectors = new LinkedHashMap<ComponentSelector, SelectorState>(5 * graphSize / 2);
        this.queue = new ArrayDeque<NodeState>(graphSize);
        this.resolveOptimizations = new ResolveOptimizations();
        this.attributeDesugaring = new AttributeDesugaring(attributesFactory);
        ComponentState rootVersion = this.getRevision(rootResult.getId(), rootResult.getModuleVersionId(), rootResult.getMetadata());
        ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(rootVersion.getId(), rootConfigurationName);
        ConfigurationMetadata configurationMetadata = rootVersion.getMetadata().getConfiguration(id.getConfiguration());
        this.root = new RootNode((Long)idGenerator.generateId(), rootVersion, id, this, configurationMetadata);
        this.nodes.put(this.root.getResolvedConfigurationId(), this.root);
        this.root.getComponent().getModule().select(this.root.getComponent());
        this.replaceSelectionWithConflictResultAction = new ReplaceSelectionWithConflictResultAction(this);
        this.selectorStateResolver = new SelectorStateResolver<ComponentState>(conflictResolver, this, rootVersion, this.resolveOptimizations);
        this.getModule(rootResult.getModuleVersionId().getModule()).setSelectorStateResolver(this.selectorStateResolver);
    }

    public Collection<ModuleResolveState> getModules() {
        return this.modules.values();
    }

    Spec<? super DependencyMetadata> getEdgeFilter() {
        return this.edgeFilter;
    }

    RootNode getRoot() {
        return this.root;
    }

    public ModuleResolveState getModule(ModuleIdentifier id) {
        return this.modules.computeIfAbsent(id, mid -> new ModuleResolveState(this.idGenerator, id, this.metaDataResolver, this.attributesFactory, this.versionComparator, this.versionParser, this.selectorStateResolver, this.resolveOptimizations));
    }

    @Override
    public ComponentState getRevision(ComponentIdentifier componentIdentifier, ModuleVersionIdentifier id, ComponentResolveMetadata metadata) {
        ComponentState componentState = this.getModule(id.getModule()).getVersion(id, componentIdentifier);
        if (!componentState.alreadyResolved()) {
            componentState.setMetadata(metadata);
        }
        return componentState;
    }

    public Collection<NodeState> getNodes() {
        return this.nodes.values();
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public NodeState getNode(ComponentState module, ConfigurationMetadata configurationMetadata) {
        ResolvedConfigurationIdentifier id = new ResolvedConfigurationIdentifier(module.getId(), configurationMetadata.getName());
        return this.nodes.computeIfAbsent(id, rci -> new NodeState((Long)this.idGenerator.generateId(), id, module, this, configurationMetadata));
    }

    public Collection<SelectorState> getSelectors() {
        return this.selectors.values();
    }

    public SelectorState getSelector(DependencyState dependencyState) {
        SelectorState selectorState = this.selectors.computeIfAbsent(dependencyState.getRequested(), req -> {
            ModuleIdentifier moduleIdentifier = dependencyState.getModuleIdentifier();
            return new SelectorState((Long)this.idGenerator.generateId(), dependencyState, this.idResolver, this, moduleIdentifier);
        });
        selectorState.update(dependencyState);
        return selectorState;
    }

    public NodeState peek() {
        return this.queue.isEmpty() ? null : this.queue.getFirst();
    }

    public NodeState pop() {
        NodeState next = this.queue.removeFirst();
        return next.dequeue();
    }

    public void onMoreSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addLast(node);
        }
    }

    public void onFewerSelected(NodeState node) {
        if (node.enqueue()) {
            this.queue.addFirst(node);
        }
    }

    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    public ModuleExclusions getModuleExclusions() {
        return this.moduleExclusions;
    }

    public DeselectVersionAction getDeselectVersionAction() {
        return this.deselectVersionAction;
    }

    public ReplaceSelectionWithConflictResultAction getReplaceSelectionWithConflictResultAction() {
        return this.replaceSelectionWithConflictResultAction;
    }

    public ComponentSelectorConverter getComponentSelectorConverter() {
        return this.componentSelectorConverter;
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    public DependencySubstitutionApplicator getDependencySubstitutionApplicator() {
        return this.dependencySubstitutionApplicator;
    }

    PendingDependenciesVisitor newPendingDependenciesVisitor() {
        return new DefaultPendingDependenciesVisitor(this);
    }

    ResolvedVersionConstraint resolveVersionConstraint(ComponentSelector selector) {
        if (selector instanceof ModuleComponentSelector) {
            VersionConstraint vc = ((ModuleComponentSelector)selector).getVersionConstraint();
            return this.resolvedVersionConstraints.computeIfAbsent(vc, key -> new DefaultResolvedVersionConstraint((VersionConstraint)key, this.versionSelectorScheme));
        }
        return null;
    }

    ImmutableAttributes desugar(ImmutableAttributes attributes) {
        return this.attributeDesugaring.desugar(attributes);
    }

    ComponentSelector desugarSelector(ComponentSelector requested) {
        return this.attributeDesugaring.desugarSelector(requested);
    }

    AttributeDesugaring getAttributeDesugaring() {
        return this.attributeDesugaring;
    }

    void virtualPlatformInUse() {
        this.resolveOptimizations.declareVirtualPlatformInUse();
    }

    ResolveOptimizations getResolveOptimizations() {
        return this.resolveOptimizations;
    }
}

