/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.tasks.compile.AnnotationAnnotationValue;
import org.gradle.api.internal.tasks.compile.AnnotationMember;
import org.gradle.api.internal.tasks.compile.AnnotationValue;
import org.gradle.api.internal.tasks.compile.ArrayAnnotationValue;
import org.gradle.api.internal.tasks.compile.EnumAnnotationValue;
import org.gradle.api.internal.tasks.compile.SimpleAnnotationValue;
import org.objectweb.asm.AnnotationVisitor;

public class SortingAnnotationVisitor
extends AnnotationVisitor {
    private final List<AnnotationValue<?>> annotationValues = Lists.newLinkedList();
    private final AnnotationMember annotation;
    private SortingAnnotationVisitor parentVisitor;
    private String annotationValueName;
    private String arrayValueName;

    public SortingAnnotationVisitor(AnnotationMember parentAnnotation, AnnotationVisitor av) {
        super(458752, av);
        this.annotation = parentAnnotation;
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationMember annotation = new AnnotationMember(desc, true);
        SortingAnnotationVisitor visitor = new SortingAnnotationVisitor(annotation, super.visitAnnotation(name, desc));
        visitor.parentVisitor = this;
        visitor.annotationValueName = this.nameOrValue(name);
        return visitor;
    }

    public void visit(String name, Object value) {
        this.annotationValues.add(new SimpleAnnotationValue(this.nameOrValue(name), value));
        super.visit(name, value);
    }

    public AnnotationVisitor visitArray(String name) {
        SortingAnnotationVisitor visitor = new SortingAnnotationVisitor(this.annotation, super.visitArray(name));
        visitor.arrayValueName = name;
        return visitor;
    }

    public void visitEnum(String name, String desc, String value) {
        this.annotationValues.add(new EnumAnnotationValue(this.nameOrValue(name), value, desc));
        super.visitEnum(name, desc, value);
    }

    public void visitEnd() {
        if (this.annotationValueName != null) {
            AnnotationAnnotationValue value = new AnnotationAnnotationValue(this.annotationValueName, this.annotation);
            this.parentVisitor.annotationValues.add(value);
            this.annotationValueName = null;
        } else if (this.arrayValueName != null) {
            ArrayAnnotationValue value = new ArrayAnnotationValue(this.arrayValueName, this.annotationValues.toArray(new AnnotationValue[0]));
            this.annotation.addValue(value);
            this.arrayValueName = null;
        }
        this.annotation.addValues(this.annotationValues);
        this.annotationValues.clear();
        super.visitEnd();
    }

    private String nameOrValue(String name) {
        return name == null ? "value" : name;
    }
}

